/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic$class;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001>\u0011A!V;jI*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tqA*Z1g\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\tO_:$W\r^3s[&t\u0017n\u001d;jGB\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003)\u0011\u0018M\u001c3p[N+W\rZ\u000b\u0002GA\u0019\u0001\u0004\n\u0014\n\u0005\u0015J\"AB(qi&|g\u000e\u0005\u0002\u0019O%\u0011\u0001&\u0007\u0002\u0005\u0019>tw\r\u0003\u0005+\u0001\tE\t\u0015!\u0003$\u0003-\u0011\u0018M\u001c3p[N+W\r\u001a\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\tqs\u0006\u0005\u0002\u0012\u0001!9\u0011e\u000bI\u0001\u0002\u0004\u0019\u0003\"\u0002\u0017\u0001\t\u0003\tD#\u0001\u0018\t\u0011M\u0002\u0001R1A\u0005BQ\n\u0001B]3t_24X\rZ\u000b\u0002kA\u0011\u0001DN\u0005\u0003oe\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005:\u0001!\u0005\t\u0015)\u00036\u0003%\u0011Xm]8mm\u0016$\u0007\u0005C\u0003<\u0001\u0011\u0005C'\u0001\u0005ok2d\u0017M\u00197f\u0011\u0015i\u0004\u0001\"\u0011?\u0003!!\u0017\r^1UsB,W#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0011!\u0002;za\u0016\u001c\u0018B\u0001#B\u0005!!\u0015\r^1UsB,\u0007\"\u0003$\u0001\u0001\u0004\u0005\t\u0015)\u0003H\u0003=\u0011\u0018M\u001c3p[\u001e+g.\u001a:bi>\u0014\bC\u0001%L\u001b\u0005I%B\u0001&\u0005\u0003\u0011)H/\u001b7\n\u00051K%a\u0005*b]\u0012|W.V+J\t\u001e+g.\u001a:bi>\u0014\bFA#O!\tAr*\u0003\u0002Q3\tIAO]1og&,g\u000e\u001e\u0005\u0006%\u0002!\tfU\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0002U/B\u0011\u0001$V\u0005\u0003-f\u0011A!\u00168ji\")\u0001,\u0015a\u00013\u0006q\u0001/\u0019:uSRLwN\\%oI\u0016D\bC\u0001\r[\u0013\tY\u0016DA\u0002J]RDQ!\u0018\u0001\u0005Ry\u000bA\"\u001a<bY&sG/\u001a:oC2$\"a\u00182\u0011\u0005a\u0001\u0017BA1\u001a\u0005\r\te.\u001f\u0005\u0006Gr\u0003\r\u0001Z\u0001\u0006S:\u0004X\u000f\u001e\t\u0003K\u001al\u0011\u0001B\u0005\u0003O\u0012\u00111\"\u00138uKJt\u0017\r\u001c*po\")\u0011\u000e\u0001C!U\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004WF4\bC\u00017p\u001b\u0005i'B\u00018\u0003\u0003\u001d\u0019w\u000eZ3hK:L!\u0001]7\u0003\u0011\u0015C\bO]\"pI\u0016DQA\u001d5A\u0002M\f1a\u0019;y!\taG/\u0003\u0002v[\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B<i\u0001\u0004Y\u0017AA3w\u0011\u001dI\b!!A\u0005\u0002i\fAaY8qsR\u0011af\u001f\u0005\bCa\u0004\n\u00111\u0001$\u0011\u001di\b!%A\u0005\u0002y\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001\u0000U\r\u0019\u0013\u0011A\u0016\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0005v]\u000eDWmY6fI*\u0019\u0011QB\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0005\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u0003\u0001\u0002\u0002\u0013\u0005\u0013qC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#!\b\u0003\rM#(/\u001b8h\u0011%\tY\u0003AA\u0001\n\u0003\ti#\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001Z\u0011%\t\t\u0004AA\u0001\n\u0003\t\u0019$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007}\u000b)\u0004C\u0005\u00028\u0005=\u0012\u0011!a\u00013\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000fzVBAA\"\u0015\r\t)%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004k\u0005E\u0003\"CA\u001c\u0003\u0017\n\t\u00111\u0001`\u0011%\t)\u0006AA\u0001\n\u0003\n9&\u0001\u0004fcV\fGn\u001d\u000b\u0004k\u0005e\u0003\"CA\u001c\u0003'\n\t\u00111\u0001`Q-\u0001\u0011QLA2\u0003K\nI'a\u001b\u0011\u0007E\ty&C\u0002\u0002b\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002h\u0005\t\u0019a\u0018$V\u001d\u000e{\u0006&\u000b\u0011.AI+G/\u001e:og\u0002\ng\u000eI;oSZ,'o]1mYf\u0004SO\\5rk\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:!QU+\u0016\nR\u0015!gR\u0014\u0018N\\4/AQCW\r\t<bYV,\u0007%[:!e\u0016$XO\u001d8fI\u0002\n7\u000fI1!G\u0006twN\\5dC2\u0004S+V%EAM2Tf\u00195be\u0006\u001cG/\u001a:!gR\u0014\u0018N\\4/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA7\u0003YS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iY:\u0004g\u000e3:e5\u0002$G\u001a\u001b.ia\nt'\f\u001d2cYj\u0013\rN24EJ\u001aTM\u000e\u001a7m)\u0001\u0003eB\u0005\u0002r\t\t\t\u0011#\u0001\u0002t\u0005!Q+^5e!\r\t\u0012Q\u000f\u0004\t\u0003\t\t\t\u0011#\u0001\u0002xM)\u0011QOA=;A1\u00111PAAG9j!!! \u000b\u0007\u0005}\u0014$A\u0004sk:$\u0018.\\3\n\t\u0005\r\u0015Q\u0010\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004b\u0002\u0017\u0002v\u0011\u0005\u0011q\u0011\u000b\u0003\u0003gB!\"a#\u0002v\u0005\u0005IQIAG\u0003!!xn\u0015;sS:<GCAA\r\u0011)\t\t*!\u001e\u0002\u0002\u0013\u0005\u00151S\u0001\u0006CB\u0004H.\u001f\u000b\u0004]\u0005U\u0005\u0002C\u0011\u0002\u0010B\u0005\t\u0019A\u0012\t\u0015\u0005e\u0015QOA\u0001\n\u0003\u000bY*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0015q\u0014\t\u00041\u0011\u001a\u0003\"CAQ\u0003/\u000b\t\u00111\u0001/\u0003\rAH\u0005\r\u0005\n\u0003K\u000b)(%A\u0005\u0002y\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004\"CAU\u0003k\n\n\u0011\"\u0001\u007f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0004BCAW\u0003k\n\t\u0011\"\u0003\u00020\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\f\u0005\u0003\u0002\u001c\u0005M\u0016\u0002BA[\u0003;\u0011aa\u00142kK\u000e$\b")
public class Uuid
extends LeafExpression
implements Nondeterministic,
Serializable {
    private final Option<Object> randomSeed;
    private boolean resolved;
    private transient RandomUUIDGenerator randomGenerator;
    private final boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid uuid) {
        return Uuid$.MODULE$.unapply(uuid);
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> function1) {
        return Uuid$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Uuid> compose(Function1<A, Option<Object>> function1) {
        return Uuid$.MODULE$.compose(function1);
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.resolved;
        }
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic$class.deterministic(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.deterministic;
        }
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic$class.foldable(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic$class.initialize(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic$class.eval(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic$class.eval$default$1(this);
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState(x$1, x$2, x$5, x$3, x$4);
        ctx.addPartitionInitializationStatement(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{randomGen}))).append((Object)"new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "L + partitionIndex);"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.randomSeed().get()}))).toString());
        return ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), "false", ev.copy$default$3());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.randomSeed();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic$class.$init$(this);
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }
}

