/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.IOException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepositoryManager;

@Deprecated
@Mojo(name="remove-project-artifact", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class RemoveLocalArtifactMojo
extends AbstractMojo {
    @Parameter(defaultValue="true", property="buildhelper.removeAll")
    private boolean removeAll;
    @Parameter(defaultValue="true", property="buildhelper.failOnError")
    private boolean failOnError;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repoSession;

    public void execute() throws MojoExecutionException {
        LocalRepositoryManager lrm = this.repoSession.getLocalRepositoryManager();
        String artifactPath = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()));
        File repoBasedir = lrm.getRepository().getBasedir();
        File localArtifactFile = new File(repoBasedir, artifactPath);
        File localArtifactDirectory = localArtifactFile.getParentFile();
        if (this.removeAll) {
            localArtifactDirectory = localArtifactDirectory.getParentFile();
        }
        try {
            FileUtils.deleteDirectory((File)localArtifactDirectory);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(localArtifactDirectory.getAbsolutePath() + " removed."));
            }
        }
        catch (IOException e) {
            String failureMessage = "Cannot delete " + localArtifactDirectory;
            if (this.failOnError) {
                throw new MojoExecutionException(failureMessage);
            }
            this.getLog().warn((CharSequence)failureMessage);
        }
    }
}

