/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.pool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.pool.Connection;
import org.csource.fastdfs.pool.ConnectionFactory;

public class ConnectionManager {
    private InetSocketAddress inetSocketAddress;
    private AtomicInteger totalCount = new AtomicInteger();
    private AtomicInteger freeCount = new AtomicInteger();
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition condition = this.lock.newCondition();
    private LinkedList<Connection> freeConnections = new LinkedList();

    private ConnectionManager() {
    }

    public ConnectionManager(InetSocketAddress socketAddress) {
        this.inetSocketAddress = socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection() throws MyException {
        this.lock.lock();
        try {
            Connection connection = null;
            while (true) {
                if (this.freeCount.get() > 0) {
                    this.freeCount.decrementAndGet();
                    connection = this.freeConnections.poll();
                    if (!connection.isAvaliable() || System.currentTimeMillis() - connection.getLastAccessTime() > (long)ClientGlobal.g_connection_pool_max_idle_time) {
                        this.closeConnection(connection);
                        continue;
                    }
                    if (!connection.isNeedActiveTest()) break;
                    boolean isActive = false;
                    try {
                        isActive = connection.activeTest();
                    }
                    catch (IOException e) {
                        System.err.println("send to server[" + this.inetSocketAddress.getAddress().getHostAddress() + ":" + this.inetSocketAddress.getPort() + "] active test error ,emsg:" + e.getMessage());
                        isActive = false;
                    }
                    if (!isActive) {
                        this.closeConnection(connection);
                        continue;
                    }
                    connection.setNeedActiveTest(false);
                    break;
                }
                if (ClientGlobal.g_connection_pool_max_count_per_entry == 0 || this.totalCount.get() < ClientGlobal.g_connection_pool_max_count_per_entry) {
                    connection = ConnectionFactory.create(this.inetSocketAddress);
                    this.totalCount.incrementAndGet();
                    break;
                }
                try {
                    if (!this.condition.await(ClientGlobal.g_connection_pool_max_wait_time_in_ms, TimeUnit.MILLISECONDS)) throw new MyException("connect to server " + this.inetSocketAddress.getAddress().getHostAddress() + ":" + this.inetSocketAddress.getPort() + " fail, wait_time > " + ClientGlobal.g_connection_pool_max_wait_time_in_ms + "ms");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new MyException("connect to server " + this.inetSocketAddress.getAddress().getHostAddress() + ":" + this.inetSocketAddress.getPort() + " fail, emsg:" + e.getMessage());
                }
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.lock.lock();
        try {
            connection.setLastAccessTime(System.currentTimeMillis());
            this.freeConnections.add(connection);
            this.freeCount.incrementAndGet();
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                this.totalCount.decrementAndGet();
                connection.closeDirectly();
            }
        }
        catch (IOException e) {
            System.err.println("close socket[" + this.inetSocketAddress.getAddress().getHostAddress() + ":" + this.inetSocketAddress.getPort() + "] error ,emsg:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setActiveTestFlag() {
        if (this.freeCount.get() > 0) {
            this.lock.lock();
            try {
                for (Connection freeConnection : this.freeConnections) {
                    freeConnection.setNeedActiveTest(true);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String toString() {
        return "ConnectionManager{ip:port='" + this.inetSocketAddress.getAddress().getHostAddress() + ":" + this.inetSocketAddress.getPort() + ", totalCount=" + this.totalCount + ", freeCount=" + this.freeCount + ", freeConnections =" + this.freeConnections + '}';
    }
}

