/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs.pool;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.csource.common.MyException;
import org.csource.fastdfs.pool.Connection;
import org.csource.fastdfs.pool.ConnectionManager;

public class ConnectionPool {
    private static final ConcurrentHashMap<String, ConnectionManager> CP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnection(InetSocketAddress socketAddress) throws MyException {
        if (socketAddress == null) {
            return null;
        }
        String key = ConnectionPool.getKey(socketAddress);
        ConnectionManager connectionManager = CP.get(key);
        if (connectionManager != null) return connectionManager.getConnection();
        Class<ConnectionPool> clazz = ConnectionPool.class;
        synchronized (ConnectionPool.class) {
            connectionManager = CP.get(key);
            if (connectionManager != null) return connectionManager.getConnection();
            connectionManager = new ConnectionManager(socketAddress);
            CP.put(key, connectionManager);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return connectionManager.getConnection();
        }
    }

    public static void releaseConnection(Connection connection) throws IOException {
        if (connection == null) {
            return;
        }
        String key = ConnectionPool.getKey(connection.getInetSocketAddress());
        ConnectionManager connectionManager = CP.get(key);
        if (connectionManager != null) {
            connectionManager.releaseConnection(connection);
        } else {
            connection.closeDirectly();
        }
    }

    public static void closeConnection(Connection connection) throws IOException {
        if (connection == null) {
            return;
        }
        String key = ConnectionPool.getKey(connection.getInetSocketAddress());
        ConnectionManager connectionManager = CP.get(key);
        if (connectionManager != null) {
            connectionManager.closeConnection(connection);
            connectionManager.setActiveTestFlag();
        } else {
            connection.closeDirectly();
        }
    }

    private static String getKey(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        return String.format("%s:%s", socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
    }

    public String toString() {
        if (!CP.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, ConnectionManager> managerEntry : CP.entrySet()) {
                builder.append("key:[" + managerEntry.getKey() + " ]-------- entry:" + managerEntry.getValue() + "\n");
            }
            return builder.toString();
        }
        return null;
    }
}

