/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.cloopen.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.cloopen.util.CloopenHelper;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloopenSmsImpl
extends AbstractSmsBlend<CloopenConfig> {
    private static final Logger log = LoggerFactory.getLogger(CloopenSmsImpl.class);

    public CloopenSmsImpl(CloopenConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public CloopenSmsImpl(CloopenConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "cloopen";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        return this.massTexting(Collections.singletonList(phone), message);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((CloopenConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.massTexting(Collections.singletonList(phone), templateId, messages);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(IdUtil.fastSimpleUUID(), message);
        return this.massTexting(phones, ((CloopenConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        CloopenHelper helper = new CloopenHelper((CloopenConfig)this.getConfig(), this.http);
        HashMap paramMap = MapUtil.newHashMap((int)4, (boolean)true);
        paramMap.put("to", String.join((CharSequence)",", phones));
        paramMap.put("appId", ((CloopenConfig)this.getConfig()).getSdkAppId());
        paramMap.put("templateId", templateId);
        paramMap.put("datas", messages.keySet().stream().map(messages::get).toArray(String[]::new));
        return helper.smsResponse(paramMap);
    }
}

