/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.danmi.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.utils.SmsRespUtils;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.danmi.config.DanMiConfig;
import org.dromara.sms4j.danmi.utils.DanMiUtils;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanMiSmsImpl
extends AbstractSmsBlend<DanMiConfig> {
    private static final Logger log = LoggerFactory.getLogger(DanMiSmsImpl.class);
    private int retry = 0;

    public DanMiSmsImpl(DanMiConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public DanMiSmsImpl(DanMiConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "danmi";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        if (StrUtil.isBlank((CharSequence)phone)) {
            log.error("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new SmsBlendException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> phones = phone.contains(",") ? SmsUtils.splitTrimComma((String)phone) : Collections.singletonList(phone);
        return this.massTexting(phones, message);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.getSmsResponse(phones, message, ((DanMiConfig)this.getConfig()).getTemplateId());
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        throw new SmsBlendException("\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    public SmsResponse queryBalance() {
        return this.getSmsResponse(null, null, null);
    }

    public SmsResponse voiceCode(String called, String verifyCode) {
        return this.getSmsResponse(Collections.singletonList(called), verifyCode, null);
    }

    public SmsResponse voiceNotify(String called, String notifyFileId) {
        return this.getSmsResponse(Collections.singletonList(called), notifyFileId, null);
    }

    public SmsResponse voiceTemplate(String called, String templateId, String param) {
        return this.getSmsResponse(Collections.singletonList(called), param, templateId);
    }

    private SmsResponse getSmsResponse(List<String> phones, String message, String templateId) {
        SmsResponse smsResponse;
        DanMiConfig config = (DanMiConfig)this.getConfig();
        try {
            String url = config.getHost() + config.getAction();
            smsResponse = this.getResponse(this.http.postJson(url, DanMiUtils.buildHeaders(), DanMiUtils.buildBody(config, phones, message, templateId)));
        }
        catch (SmsBlendException e) {
            smsResponse = this.errorResp(e.message);
        }
        if (smsResponse.isSuccess() || this.retry == config.getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phones, message, templateId);
    }

    private SmsResponse requestRetry(List<String> phones, String message, String templateId) {
        this.http.safeSleep(((DanMiConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.getSmsResponse(phones, message, templateId);
    }

    private SmsResponse getResponse(JSONObject resJson) {
        return SmsRespUtils.resp((Object)resJson, (boolean)"00000".equals(resJson.getStr((Object)"respCode")), (String)this.getConfigId());
    }
}

