/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.danmi.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import java.util.LinkedHashMap;
import java.util.List;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.danmi.config.DanMiConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DanMiUtils {
    private static final Logger log = LoggerFactory.getLogger(DanMiUtils.class);

    public static LinkedHashMap<String, String> buildHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(1);
        headers.put("Content-Type", "application/json");
        return headers;
    }

    public static LinkedHashMap<String, Object> buildBody(DanMiConfig config, List<String> phones, String message, String templateId) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("respDataType", "JSON");
        body.put("accountSid", config.getAccessKeyId());
        switch (config.getAction()) {
            case "distributor/sendSMS": {
                if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{message, templateId})) {
                    log.error("message and templateId can not be empty at the same time");
                    throw new SmsBlendException("message and templateId can not be empty at the same time");
                }
                if (StrUtil.isNotBlank((CharSequence)templateId)) {
                    body.put("templateid", templateId);
                }
                if (StrUtil.isNotBlank((CharSequence)message)) {
                    body.put("smsContent", URLEncodeUtil.encode((String)message));
                }
                if (CollUtil.isEmpty(phones)) {
                    log.error("phones can not be empty");
                    throw new SmsBlendException("phones can not be empty");
                }
                body.put("to", SmsUtils.addCodePrefixIfNot(phones));
                break;
            }
            case "distributor/user/query": {
                break;
            }
            case "voice/voiceCode": {
                if (CollUtil.isEmpty(phones) || phones.size() != 1) {
                    log.error("called can not be empty or phone must be only one");
                    throw new SmsBlendException("called can not be empty or phone must be only one");
                }
                body.put("called", SmsUtils.addCodePrefixIfNot((String)phones.get(0)));
                if (StrUtil.isBlank((CharSequence)message)) {
                    log.error("verifyCode can not be empty");
                    throw new SmsBlendException("verifyCode can not be empty");
                }
                body.put("verifyCode", message);
                break;
            }
            case "voice/voiceNotify": {
                if (CollUtil.isEmpty(phones) || phones.size() != 1) {
                    log.error("called can not be empty or phone must be only one");
                    throw new SmsBlendException("called can not be empty or phone must be only one");
                }
                body.put("called", SmsUtils.addCodePrefixIfNot((String)phones.get(0)));
                if (StrUtil.isBlank((CharSequence)message)) {
                    log.error("notifyFileId can not be empty");
                    throw new SmsBlendException("notifyFileId can not be empty");
                }
                body.put("notifyFileId", message);
                break;
            }
            case "voice/voiceTemplate": {
                if (CollUtil.isEmpty(phones) || phones.size() != 1) {
                    log.error("called can not be empty or phone must be only one");
                    throw new SmsBlendException("called can not be empty or phone must be only one");
                }
                body.put("called", SmsUtils.addCodePrefixIfNot((String)phones.get(0)));
                if (StrUtil.isEmpty((CharSequence)templateId)) {
                    log.error("templateId can not be empty");
                    throw new SmsBlendException("templateId can not be empty");
                }
                body.put("templateId", templateId);
                if (StrUtil.isEmpty((CharSequence)message)) {
                    log.error("param can not be empty");
                    throw new SmsBlendException("param can not be empty");
                }
                body.put("param", message);
                break;
            }
            default: {
                log.error("action not found");
                throw new SmsBlendException("action not found");
            }
        }
        long timestamp = System.currentTimeMillis();
        body.put("timestamp", timestamp);
        body.put("sig", DanMiUtils.sign(config.getAccessKeyId(), config.getAccessKeySecret(), timestamp));
        return body;
    }

    private static String sign(String accessKeyId, String accessKeySecret, long timestamp) {
        return DigestUtil.md5Hex((String)(accessKeyId + accessKeySecret + timestamp));
    }

    private DanMiUtils() {
    }
}

