/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.provider.factory;

import cn.hutool.core.collection.CollUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;

public class ProviderFactoryHolder {
    private static final Map<String, BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> FACTORIES = new ConcurrentHashMap<String, BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>>();

    public static void registerFactory(BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig> factory) {
        if (factory == null) {
            throw new SmsBlendException("\u6ce8\u518c\u4f9b\u5e94\u5546\u5de5\u5382\u5931\u8d25\uff0c\u5de5\u5382\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FACTORIES.put(factory.getSupplier(), factory);
    }

    public static void registerFactory(List<BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig>> factoryList) {
        if (CollUtil.isEmpty(factoryList)) {
            return;
        }
        for (BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig> factory : factoryList) {
            if (factory == null) continue;
            ProviderFactoryHolder.registerFactory(factory);
        }
    }

    public static BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig> requireForSupplier(String supplier) {
        return FACTORIES.getOrDefault(supplier, null);
    }
}

