/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.submail.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.DigestUtil;
import java.util.LinkedHashMap;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubMailUtils {
    private static final Logger log = LoggerFactory.getLogger(SubMailUtils.class);

    public static LinkedHashMap<String, String> buildHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(1);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return headers;
    }

    public static String signature(LinkedHashMap<String, Object> body, String signType, String accessKeyId, String accessKeySecret, String ... excludes) {
        if (StrUtil.containsAnyIgnoreCase((CharSequence)signType, (CharSequence[])new CharSequence[]{DigestAlgorithm.MD5.getValue(), DigestAlgorithm.SHA1.getValue()})) {
            StringBuilder sb = new StringBuilder();
            sb.append(accessKeyId).append(accessKeySecret);
            if ("2".equals(Convert.toStr((Object)body.get("sign_version")))) {
                sb.append(SmsUtils.sortedParamsAsc(body, (String[])excludes));
            } else {
                sb.append(SmsUtils.sortedParamsAsc(body, (String[])new String[0]));
            }
            sb.append(accessKeyId).append(accessKeySecret);
            if (signType.equalsIgnoreCase(DigestAlgorithm.MD5.getValue())) {
                return DigestUtil.md5Hex((String)sb.toString());
            }
            return DigestUtil.sha1Hex((String)sb.toString());
        }
        return accessKeySecret;
    }
}

