/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.TypeResolver;

public class MetadataBuildingContextTestingImpl
implements MetadataBuildingContext {
    private final MetadataBuildingOptions buildingOptions;
    private final MappingDefaults mappingDefaults;
    private final InFlightMetadataCollector metadataCollector;
    private final ClassLoaderAccessImpl classLoaderAccess;
    private final ObjectNameNormalizer objectNameNormalizer;

    public MetadataBuildingContextTestingImpl() {
        this(new StandardServiceRegistryBuilder().build());
    }

    public MetadataBuildingContextTestingImpl(StandardServiceRegistry serviceRegistry) {
        this.buildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        this.mappingDefaults = new MetadataBuilderImpl.MappingDefaultsImpl(serviceRegistry);
        this.metadataCollector = new InFlightMetadataCollectorImpl(this.buildingOptions, new TypeResolver());
        this.classLoaderAccess = new ClassLoaderAccessImpl(null, (ServiceRegistry)serviceRegistry);
        this.objectNameNormalizer = new ObjectNameNormalizer(){

            protected MetadataBuildingContext getBuildingContext() {
                return MetadataBuildingContextTestingImpl.this;
            }
        };
    }

    public MetadataBuildingOptions getBuildingOptions() {
        return this.buildingOptions;
    }

    public MappingDefaults getMappingDefaults() {
        return this.mappingDefaults;
    }

    public InFlightMetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    public ClassLoaderAccess getClassLoaderAccess() {
        return this.classLoaderAccess;
    }

    public ObjectNameNormalizer getObjectNameNormalizer() {
        return this.objectNameNormalizer;
    }
}

