/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.font.type1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.pfb.PfbParser;
import org.apache.fontbox.type1.Type1Font;

public class Type1SegSplitParser {
    private static final byte[] EEXEC = new byte[]{101, 101, 120, 101, 99, 13};

    public static Type1Font parse(byte[] raw) throws IOException {
        byte[][] segments = Type1SegSplitParser.split(raw);
        if (segments == null) {
            return null;
        }
        return Type1Font.createWithSegments((byte[])segments[0], (byte[])segments[1]);
    }

    public static Type1Font parse(InputStream in) throws IOException {
        byte[] buf = IOUtils.toByteArray((InputStream)in);
        return Type1SegSplitParser.parse(buf);
    }

    public static boolean isType1(byte[] raw) {
        if (raw == null || raw.length <= 2) {
            return false;
        }
        if ((raw[0] & 0xFF) == 128 && (raw[1] & 0xFF) == 1) {
            return true;
        }
        return raw[0] == 37 && raw[1] == 33;
    }

    public static byte[][] split(byte[] raw) throws IOException {
        if (raw == null || raw.length <= 2) {
            return null;
        }
        if ((raw[0] & 0xFF) == 128 && (raw[1] & 0xFF) == 1) {
            PfbParser pfbParser = new PfbParser(raw);
            return new byte[][]{pfbParser.getSegment1(), pfbParser.getSegment2()};
        }
        int off = Type1SegSplitParser.indexOf(raw, EEXEC);
        if (off == -1) {
            return null;
        }
        byte[] asciiSeg = Arrays.copyOf(raw, off += EEXEC.length);
        byte[] binSeg = Arrays.copyOfRange(raw, off, raw.length);
        return new byte[][]{asciiSeg, binSeg};
    }

    public static int indexOf(byte[] array, byte[] target) {
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

