/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import com.itextpdf.kernel.colors.DeviceRgb;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.util.Matrix;
import org.ofdrw.converter.point.Tuple2;
import org.ofdrw.converter.utils.MatrixUtils;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;

public class CommonUtil {
    public static double millimetersToPixel(double mm, double dpi) {
        return mm * dpi / (double)25.4f;
    }

    public static double pixelToMillimeters(double px, double dpi) {
        return px * (double)25.4f / dpi;
    }

    public static double dpiToPpm(int dpi) {
        return 0.03937007874015748 * (double)dpi;
    }

    public static float[] doubleArrayToFloatArray(Double[] doubleArray) {
        if (Objects.isNull(doubleArray)) {
            return new float[0];
        }
        float[] floatArray = new float[doubleArray.length];
        int index = 0;
        for (Double item : doubleArray) {
            floatArray[index] = item.floatValue();
            ++index;
        }
        return floatArray;
    }

    public static ST_Box getPageBox(CT_PageArea pageArea, double width, double height) {
        ST_Box documentBox = null;
        try {
            documentBox = pageArea.getPhysicalBox();
            if (documentBox == null) {
                documentBox = pageArea.getApplicationBox();
            }
            if (documentBox == null) {
                documentBox = pageArea.getContentBox();
            }
        }
        catch (Exception e) {
            documentBox = new ST_Box(0.0, 0.0, width, height);
        }
        return documentBox;
    }

    public static String generateTempFilePath() {
        return System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID().toString();
    }

    public static double converterDpi(double len) {
        return CommonUtil.millimetersToPixel(len, 72.0);
    }

    public static PDColor convertPDColor(ST_Array colorArray) {
        PDColor color = null;
        String colorStr = colorArray.toString();
        if (colorStr.indexOf("#") != -1) {
            String[] rgbStr = colorStr.split(" ");
            if (rgbStr.length >= 3) {
                String r = rgbStr[0].replaceAll("#", "");
                String g = rgbStr[1].replaceAll("#", "");
                String b = rgbStr[2].replaceAll("#", "");
                if (r.length() == 1) {
                    r = r + "0";
                }
                if (g.length() == 1) {
                    g = g + "0";
                }
                if (b.length() == 1) {
                    b = b + "0";
                }
                Color jColor = Color.decode(String.format("#%s%s%s", r, g, b));
                color = new PDColor(new float[]{(float)jColor.getRed() / 255.0f, (float)jColor.getGreen() / 255.0f, (float)jColor.getBlue() / 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            }
        } else {
            float[] colors = CommonUtil.doubleArrayToFloatArray(colorArray.toDouble());
            if (colors.length == 3) {
                color = new PDColor(new float[]{(float)((int)colors[0]) / 255.0f, (float)((int)colors[1]) / 255.0f, (float)((int)colors[2]) / 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            } else if (colors.length == 1) {
                color = new PDColor(new float[]{(float)((int)colors[0]) / 255.0f}, (PDColorSpace)PDDeviceGray.INSTANCE);
            }
        }
        return color;
    }

    public static String convertOfdColorToHtml(ST_Array colorArray) {
        String color = null;
        String colorStr = colorArray.toString();
        if (colorStr.indexOf("#") != -1) {
            colorStr = colorStr.replaceAll("#", "");
            colorStr = colorStr.replaceAll(" ", "");
            color = String.format("#%s", colorStr);
        } else {
            float[] colors = CommonUtil.doubleArrayToFloatArray(colorArray.toDouble());
            if (colors.length == 3) {
                color = String.format("rgb(%d,%d,%d)", (int)colors[0], (int)colors[1], (int)colors[2]);
            } else if (colors.length == 1) {
                color = String.format("rgb(%d,%d,%d)", (int)colors[0], (int)colors[0], (int)colors[0]);
            }
        }
        return color;
    }

    public static String matrixFrom(ST_Array ctms) {
        Double[] ctm = ctms.toDouble();
        double a = ctm[0];
        double b = ctm[1];
        double c = ctm[2];
        double d = ctm[3];
        double e = ctm[4];
        double f = ctm[5];
        String matrix = String.format("matrix(%f %f %f %f %f %f)", a, b, c, d, CommonUtil.converterDpi(e), CommonUtil.converterDpi(f));
        return matrix;
    }

    public static byte[] converJbig2(File imgFile) throws IOException {
        JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
        FileInputStream inputStream = new FileInputStream(imgFile);
        DefaultInputStreamFactory disf = new DefaultInputStreamFactory();
        ImageInputStream imageInputStream = disf.getInputStream((InputStream)inputStream);
        imageReader.setInput((Object)imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0, (ImageReadParam)imageReader.getDefaultReadParam());
        ByteArrayOutputStream bosImage = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", bosImage);
        return bosImage.toByteArray();
    }

    public static long convertV1SignTime(String time) throws ParseException {
        time = time.replaceAll("T", "");
        time = time.replaceAll("-", "");
        if ((time = time.replaceAll(":", "")).endsWith("Z")) {
            SimpleDateFormat var1 = CommonUtil.hasFractionalSeconds(time) ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : (CommonUtil.hasSeconds(time) ? new SimpleDateFormat("yyyyMMddHHmmss'Z'") : (CommonUtil.hasMinutes(time) ? new SimpleDateFormat("yyyyMMddHHmm'Z'") : new SimpleDateFormat("yyyyMMddHH'Z'")));
            var1.setTimeZone(new SimpleTimeZone(0, "Z"));
            Date date = var1.parse(time);
            return date.getTime();
        }
        return 0L;
    }

    private static boolean hasFractionalSeconds(String time) {
        for (int var1 = 0; var1 != time.length(); ++var1) {
            if (time.charAt(var1) != '.' || var1 != 14) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSeconds(String time) {
        return CommonUtil.isDigit(time, 12) && CommonUtil.isDigit(time, 13);
    }

    private static boolean hasMinutes(String time) {
        return CommonUtil.isDigit(time, 10) && CommonUtil.isDigit(time, 11);
    }

    private static boolean isDigit(String time, int var1) {
        return time.length() > var1 && time.charAt(var1) >= '0' && time.charAt(var1) <= '9';
    }

    public static org.ujmp.core.Matrix getImageMatrixFromOfd(ImageObject nImageObject, ST_Box pageBox, ST_Array compositeObjectCTM) {
        org.ujmp.core.Matrix matrix = MatrixUtils.base();
        matrix = MatrixUtils.imageMatrix(matrix, 0.0, 1.0, 0.0);
        matrix = MatrixUtils.move(matrix, 0.0, 1.0);
        if (nImageObject.getCTM() != null) {
            org.ujmp.core.Matrix ctm = MatrixUtils.base();
            ctm = ctm.mtimes(MatrixUtils.ctm(nImageObject.getCTM().toDouble()));
            matrix = matrix.mtimes(ctm);
        }
        ST_Box boundary = nImageObject.getBoundary();
        double x = boundary.getTopLeftX();
        double y = boundary.getTopLeftY();
        if (boundary == null) {
            boundary = pageBox;
        }
        if (compositeObjectCTM != null) {
            org.ujmp.core.Matrix ctm = MatrixUtils.base();
            ctm = ctm.mtimes(MatrixUtils.ctm(compositeObjectCTM.toDouble()));
            matrix = matrix.mtimes(ctm);
            double[] realPos = PointUtil.ctmCalPoint(x, y, compositeObjectCTM.toDouble());
            x = realPos[0];
            y = realPos[1];
        }
        matrix = matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, x, y));
        matrix = MatrixUtils.imageMatrix(matrix, 0.0, 1.0, 0.0);
        matrix = matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, 0.0, pageBox.getHeight()));
        matrix = matrix.mtimes(MatrixUtils.create(CommonUtil.converterDpi(1.0), 0.0, 0.0, CommonUtil.converterDpi(1.0), 0.0, 0.0));
        return matrix;
    }

    public static org.ujmp.core.Matrix getImageMatrixFromOfd(ImageObject nImageObject, ST_Box pageBox) {
        ST_Box boundary;
        org.ujmp.core.Matrix matrix = MatrixUtils.base();
        matrix = MatrixUtils.imageMatrix(matrix, 0.0, 1.0, 0.0);
        matrix = MatrixUtils.move(matrix, 0.0, 1.0);
        if (nImageObject.getCTM() != null) {
            org.ujmp.core.Matrix ctm = MatrixUtils.base();
            ctm = ctm.mtimes(MatrixUtils.ctm(nImageObject.getCTM().toDouble()));
            matrix = matrix.mtimes(ctm);
        }
        if ((boundary = nImageObject.getBoundary()) == null) {
            boundary = pageBox;
        }
        Tuple2<Double, Double> tuple2 = MatrixUtils.leftTop(matrix);
        matrix = matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, boundary.getTopLeftX(), boundary.getTopLeftY()));
        matrix = MatrixUtils.imageMatrix(matrix, 0.0, 1.0, 0.0);
        matrix = matrix.mtimes(MatrixUtils.create(1.0, 0.0, 0.0, 1.0, 0.0, pageBox.getHeight()));
        matrix = matrix.mtimes(MatrixUtils.create(CommonUtil.converterDpi(1.0), 0.0, 0.0, CommonUtil.converterDpi(1.0), 0.0, 0.0));
        return matrix;
    }

    public static Matrix toPFMatrix(org.ujmp.core.Matrix source) {
        Matrix target = new Matrix();
        target.setValue(0, 0, source.getAsFloat(new long[]{0L, 0L}));
        target.setValue(0, 1, source.getAsFloat(new long[]{0L, 1L}));
        target.setValue(1, 0, source.getAsFloat(new long[]{1L, 0L}));
        target.setValue(1, 1, source.getAsFloat(new long[]{1L, 1L}));
        target.setValue(2, 0, source.getAsFloat(new long[]{2L, 0L}));
        target.setValue(2, 1, source.getAsFloat(new long[]{2L, 1L}));
        return target;
    }

    @Deprecated
    public static com.itextpdf.kernel.colors.Color convertOfdColor(ST_Array colorArray) {
        DeviceRgb color = null;
        String colorStr = colorArray.toString();
        if (colorStr.indexOf("#") != -1) {
            String[] rgbStr = colorStr.split(" ");
            String r = rgbStr[0].replaceAll("#", "");
            String g = rgbStr[1].replaceAll("#", "");
            String b = rgbStr[2].replaceAll("#", "");
            if (r.length() == 1) {
                r = r + "0";
            }
            if (g.length() == 1) {
                g = g + "0";
            }
            if (b.length() == 1) {
                b = b + "0";
            }
            Color jColor = Color.decode(String.format("#%s%s%s", r, g, b));
            color = new DeviceRgb((float)jColor.getRed() / 255.0f, (float)jColor.getGreen() / 255.0f, (float)jColor.getBlue() / 255.0f);
        } else {
            float[] colors = CommonUtil.doubleArrayToFloatArray(colorArray.toDouble());
            if (colors.length == 3) {
                color = new DeviceRgb(colors[0] / 255.0f, (float)((int)colors[1]) / 255.0f, (float)((int)colors[2]) / 255.0f);
            }
        }
        return color;
    }
}

