/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v104.audits.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v104.audits.model.AffectedCookie;
import org.openqa.selenium.devtools.v104.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v104.audits.model.CookieExclusionReason;
import org.openqa.selenium.devtools.v104.audits.model.CookieOperation;
import org.openqa.selenium.devtools.v104.audits.model.CookieWarningReason;
import org.openqa.selenium.json.JsonInput;

public class CookieIssueDetails {
    private final Optional<AffectedCookie> cookie;
    private final Optional<String> rawCookieLine;
    private final List<CookieWarningReason> cookieWarningReasons;
    private final List<CookieExclusionReason> cookieExclusionReasons;
    private final CookieOperation operation;
    private final Optional<String> siteForCookies;
    private final Optional<String> cookieUrl;
    private final Optional<AffectedRequest> request;

    public CookieIssueDetails(Optional<AffectedCookie> cookie, Optional<String> rawCookieLine, List<CookieWarningReason> cookieWarningReasons, List<CookieExclusionReason> cookieExclusionReasons, CookieOperation operation, Optional<String> siteForCookies, Optional<String> cookieUrl, Optional<AffectedRequest> request) {
        this.cookie = cookie;
        this.rawCookieLine = rawCookieLine;
        this.cookieWarningReasons = Objects.requireNonNull(cookieWarningReasons, "cookieWarningReasons is required");
        this.cookieExclusionReasons = Objects.requireNonNull(cookieExclusionReasons, "cookieExclusionReasons is required");
        this.operation = Objects.requireNonNull(operation, "operation is required");
        this.siteForCookies = siteForCookies;
        this.cookieUrl = cookieUrl;
        this.request = request;
    }

    public Optional<AffectedCookie> getCookie() {
        return this.cookie;
    }

    public Optional<String> getRawCookieLine() {
        return this.rawCookieLine;
    }

    public List<CookieWarningReason> getCookieWarningReasons() {
        return this.cookieWarningReasons;
    }

    public List<CookieExclusionReason> getCookieExclusionReasons() {
        return this.cookieExclusionReasons;
    }

    public CookieOperation getOperation() {
        return this.operation;
    }

    public Optional<String> getSiteForCookies() {
        return this.siteForCookies;
    }

    public Optional<String> getCookieUrl() {
        return this.cookieUrl;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    private static CookieIssueDetails fromJson(JsonInput input) {
        Optional<AffectedCookie> cookie = Optional.empty();
        Optional<String> rawCookieLine = Optional.empty();
        List cookieWarningReasons = null;
        List cookieExclusionReasons = null;
        CookieOperation operation = null;
        Optional<String> siteForCookies = Optional.empty();
        Optional<String> cookieUrl = Optional.empty();
        Optional<AffectedRequest> request = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "cookie": {
                    cookie = Optional.ofNullable((AffectedCookie)input.read(AffectedCookie.class));
                    continue block20;
                }
                case "rawCookieLine": {
                    rawCookieLine = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "cookieWarningReasons": {
                    cookieWarningReasons = (List)input.read(new TypeToken<List<CookieWarningReason>>(){}.getType());
                    continue block20;
                }
                case "cookieExclusionReasons": {
                    cookieExclusionReasons = (List)input.read(new TypeToken<List<CookieExclusionReason>>(){}.getType());
                    continue block20;
                }
                case "operation": {
                    operation = (CookieOperation)((Object)input.read(CookieOperation.class));
                    continue block20;
                }
                case "siteForCookies": {
                    siteForCookies = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "cookieUrl": {
                    cookieUrl = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieIssueDetails(cookie, rawCookieLine, cookieWarningReasons, cookieExclusionReasons, operation, siteForCookies, cookieUrl, request);
    }
}

