/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v104.debugger.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class DebugSymbols {
    private final Type type;
    private final Optional<String> externalURL;

    public DebugSymbols(Type type, Optional<String> externalURL) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.externalURL = externalURL;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getExternalURL() {
        return this.externalURL;
    }

    private static DebugSymbols fromJson(JsonInput input) {
        Type type = null;
        Optional<String> externalURL = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block8;
                }
                case "externalURL": {
                    externalURL = Optional.ofNullable(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DebugSymbols(type, externalURL);
    }

    public static enum Type {
        NONE("None"),
        SOURCEMAP("SourceMap"),
        EMBEDDEDDWARF("EmbeddedDWARF"),
        EXTERNALDWARF("ExternalDWARF");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

