/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v104.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v104.runtime.model.EntryPreview;
import org.openqa.selenium.devtools.v104.runtime.model.PropertyPreview;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ObjectPreview {
    private final Type type;
    private final Optional<Subtype> subtype;
    private final Optional<String> description;
    private final Boolean overflow;
    private final List<PropertyPreview> properties;
    private final Optional<List<EntryPreview>> entries;

    public ObjectPreview(Type type, Optional<Subtype> subtype, Optional<String> description, Boolean overflow, List<PropertyPreview> properties, Optional<List<EntryPreview>> entries) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.subtype = subtype;
        this.description = description;
        this.overflow = Objects.requireNonNull(overflow, "overflow is required");
        this.properties = Objects.requireNonNull(properties, "properties is required");
        this.entries = entries;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Subtype> getSubtype() {
        return this.subtype;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Boolean getOverflow() {
        return this.overflow;
    }

    public List<PropertyPreview> getProperties() {
        return this.properties;
    }

    public Optional<List<EntryPreview>> getEntries() {
        return this.entries;
    }

    private static ObjectPreview fromJson(JsonInput input) {
        Type type = null;
        Optional<Subtype> subtype = Optional.empty();
        Optional<String> description = Optional.empty();
        Boolean overflow = false;
        List properties = null;
        Optional<List<EntryPreview>> entries = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block16;
                }
                case "subtype": {
                    subtype = Optional.ofNullable(Subtype.fromString(input.nextString()));
                    continue block16;
                }
                case "description": {
                    description = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "overflow": {
                    overflow = input.nextBoolean();
                    continue block16;
                }
                case "properties": {
                    properties = (List)input.read(new TypeToken<List<PropertyPreview>>(){}.getType());
                    continue block16;
                }
                case "entries": {
                    entries = Optional.ofNullable((List)input.read(new TypeToken<List<EntryPreview>>(){}.getType()));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ObjectPreview(type, subtype, description, overflow, properties, entries);
    }

    public static enum Subtype {
        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        DATAVIEW("dataview"),
        WEBASSEMBLYMEMORY("webassemblymemory"),
        WASMVALUE("wasmvalue");

        private String value;

        private Subtype(String value) {
            this.value = value;
        }

        public static Subtype fromString(String s) {
            return Arrays.stream(Subtype.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Subtype "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Subtype fromJson(JsonInput input) {
            return Subtype.fromString(input.nextString());
        }
    }

    public static enum Type {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol"),
        BIGINT("bigint");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

