/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

@AutoService(value={WebDriverInfo.class})
public class EdgeDriverInfo
extends ChromiumDriverInfo {
    public String getDisplayName() {
        return "Edge";
    }

    public Capabilities getCanonicalCapabilities() {
        if (!"jdk-http-client".equalsIgnoreCase(System.getProperty("webdriver.http.factory", ""))) {
            return new ImmutableCapabilities("browserName", (Object)Browser.EDGE.browserName(), "ms:edgeOptions", (Object)ImmutableMap.of((Object)"args", (Object)ImmutableList.of((Object)"--remote-allow-origins=*")));
        }
        return new ImmutableCapabilities("browserName", (Object)Browser.EDGE.browserName());
    }

    public boolean isSupporting(Capabilities capabilities) {
        return Browser.EDGE.is(capabilities.getBrowserName()) || "webview2".equalsIgnoreCase(capabilities.getBrowserName()) || capabilities.getCapability("ms:edgeOptions") != null;
    }

    public boolean isSupportingCdp() {
        return true;
    }

    public boolean isSupportingBiDi() {
        return false;
    }

    public boolean isAvailable() {
        try {
            DriverFinder.getPath((DriverService)EdgeDriverService.createDefaultService(), (Capabilities)this.getCanonicalCapabilities());
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public boolean isPresent() {
        try {
            DriverFinder.getPath((DriverService)EdgeDriverService.createDefaultService(), (Capabilities)this.getCanonicalCapabilities(), (boolean)true);
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(new EdgeOptions().merge(capabilities)));
    }
}

