/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class CreateSessionResponse {
    private final Session session;
    private final byte[] downstreamEncodedResponse;

    public CreateSessionResponse(Session session, byte[] downstreamEncodedResponse) {
        this.session = (Session)Require.nonNull((String)"Session", (Object)session);
        this.downstreamEncodedResponse = (byte[])Require.nonNull((String)"Downstream encoded response", (Object)downstreamEncodedResponse);
    }

    public Session getSession() {
        return this.session;
    }

    public byte[] getDownstreamEncodedResponse() {
        return this.downstreamEncodedResponse;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("downstreamEncodedResponse", Base64.getEncoder().encodeToString(this.downstreamEncodedResponse));
        toReturn.put("session", this.session);
        return Collections.unmodifiableMap(toReturn);
    }

    private static CreateSessionResponse fromJson(JsonInput input) {
        Session session = null;
        byte[] downstreamResponse = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "downstreamEncodedResponse": {
                    downstreamResponse = Base64.getDecoder().decode(input.nextString());
                    continue block8;
                }
                case "session": {
                    session = (Session)input.read(Session.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreateSessionResponse(session, downstreamResponse);
    }
}

