/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.security;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.logging.Logger;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class RequiresSecretFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(RequiresSecretFilter.class.getName());
    private final Secret secret;

    public RequiresSecretFilter(Secret secret) {
        this.secret = (Secret)Require.nonNull((String)"Secret", (Object)secret);
    }

    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull((String)"HTTP handler", (Object)httpHandler);
        return req -> {
            if (!this.isSecretMatch(this.secret, req)) {
                return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(401).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(Collections.singletonMap("value", ImmutableMap.of((Object)"error", (Object)"unknown error", (Object)"message", (Object)"Unauthorized access attempted to ", (Object)"stacktrace", (Object)""))));
            }
            return httpHandler.execute(req);
        };
    }

    private boolean isSecretMatch(Secret secret, HttpRequest request) {
        String header = request.getHeader("X-REGISTRATION-SECRET");
        if (header == null) {
            if (secret != null) {
                LOG.warning("Unexpectedly received registration secret to " + request);
                return false;
            }
            return true;
        }
        Secret requestSecret = new Secret(header);
        if (!secret.matches(requestSecret)) {
            LOG.warning("Unauthorized access attempted to " + request);
            return false;
        }
        return true;
    }
}

