/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.io.UncheckedIOException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class SessionNotCreated
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue queue;
    private final RequestId requestId;

    public SessionNotCreated(Tracer tracer, NewSessionQueue queue, RequestId requestId) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.queue = (NewSessionQueue)Require.nonNull((String)"New Session Queue", (Object)queue);
        this.requestId = (RequestId)Require.nonNull((String)"Request ID", (Object)requestId);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessionqueue.created_bad");){
            Tags.HTTP_REQUEST.accept(span, req);
            String message = (String)Contents.fromJson((HttpMessage)req, String.class);
            SessionNotCreatedException exception = new SessionNotCreatedException(message);
            this.queue.complete(this.requestId, (Either<SessionNotCreatedException, CreateSessionResponse>)Either.left((Object)((Object)exception)));
            HttpResponse res = new HttpResponse();
            Tags.HTTP_RESPONSE.accept(span, res);
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }
}

