/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class GetAttribute
extends SeleneseCommand<String> {
    private final String getAttribute;
    private final JavascriptLibrary library;
    private final ElementFinder finder;

    public GetAttribute(JavascriptLibrary library, ElementFinder finder) {
        this.library = library;
        this.finder = finder;
        this.getAttribute = "return (" + library.getSeleniumScript("getAttribute.js") + ").apply(null, arguments);";
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String attributeLocator, String ignored) {
        try {
            return (String)this.library.executeScript(driver, this.getAttribute, attributeLocator);
        }
        catch (WebDriverException e) {
            String[] nameAndAttribute = this.getNameAndAttribute(attributeLocator);
            WebElement element = this.finder.findElement(driver, nameAndAttribute[0]);
            return element.getAttribute(nameAndAttribute[1]);
        }
    }

    @VisibleForTesting
    protected String[] getNameAndAttribute(String attributeLocator) {
        int atSign = attributeLocator.lastIndexOf("@");
        String[] toReturn = new String[]{attributeLocator.substring(0, atSign), attributeLocator.substring(atSign + 1)};
        return toReturn;
    }
}

