/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.grid.session.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.NewSessionPayload;

public class NewSessionPipeline {
    private final List<SessionFactory> factories;
    private final SessionFactory fallback;
    private final List<Function<Capabilities, Capabilities>> mutators;

    private NewSessionPipeline(List<SessionFactory> factories, SessionFactory fallback, List<Function<Capabilities, Capabilities>> mutators) {
        this.factories = factories;
        this.fallback = fallback;
        this.mutators = mutators;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActiveSession createNewSession(NewSessionPayload payload) {
        return payload.stream().map(caps -> {
            for (Function<Capabilities, Capabilities> mutator : this.mutators) {
                caps = mutator.apply((Capabilities)caps);
            }
            return caps;
        }).map(caps -> this.factories.stream().filter(factory -> factory.test(caps)).map(factory -> (Optional)factory.apply((Object)new CreateSessionRequest(payload.getDownstreamDialects(), caps, (Map)ImmutableMap.of()))).filter(Optional::isPresent).map(Optional::get).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().orElseGet(() -> (ActiveSession)((Optional)this.fallback.apply((Object)new CreateSessionRequest(payload.getDownstreamDialects(), (Capabilities)new ImmutableCapabilities(), (Map)ImmutableMap.of()))).orElseThrow(() -> new SessionNotCreatedException("Unable to create session from " + payload)));
    }

    public static class Builder {
        private List<SessionFactory> factories = new LinkedList<SessionFactory>();
        private SessionFactory fallback = new SessionFactory(){

            public boolean test(Capabilities capabilities) {
                return false;
            }

            public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
                return Optional.empty();
            }
        };
        private List<Function<Capabilities, Capabilities>> mutators = new LinkedList<Function<Capabilities, Capabilities>>();

        private Builder() {
        }

        public Builder add(SessionFactory factory) {
            this.factories.add((SessionFactory)Require.nonNull((String)"Factory", (Object)factory));
            return this;
        }

        public Builder fallback(SessionFactory factory) {
            this.fallback = (SessionFactory)Require.nonNull((String)"Fallback", (Object)factory);
            return this;
        }

        public Builder addCapabilitiesMutator(Function<Capabilities, Capabilities> mutator) {
            this.mutators.add((Function)Require.nonNull((String)"Mutator", mutator));
            return this;
        }

        public NewSessionPipeline create() {
            return new NewSessionPipeline((List)ImmutableList.copyOf(this.factories), this.fallback, this.mutators);
        }
    }
}

