/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.logging.SessionLogs;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class GetSessionLogsHandler
implements RestishHandler<Map<String, SessionLogs>> {
    private final Response response = new Response();

    public Response getResponse() {
        return this.response;
    }

    @Override
    public Map<String, SessionLogs> handle() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SessionId sessionId : LoggingManager.perSessionLogHandler().getLoggedSessions()) {
            builder.put((Object)sessionId.toString(), (Object)LoggingManager.perSessionLogHandler().getAllLogsForSession(sessionId));
        }
        return builder.build();
    }

    public String toString() {
        return "[fetching session logs]";
    }
}

