/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.actuate.endpoint;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.health.actuate.endpoint.AdditionalHealthEndpointPath;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroup;
import org.springframework.util.Assert;

public interface HealthEndpointGroups {
    public HealthEndpointGroup getPrimary();

    public Set<String> getNames();

    public @Nullable HealthEndpointGroup get(String var1);

    default public @Nullable HealthEndpointGroup get(AdditionalHealthEndpointPath path) {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        for (String name : this.getNames()) {
            HealthEndpointGroup group = this.get(name);
            Assert.state((group != null ? 1 : 0) != 0, (String)"'group' must not be null");
            if (!path.equals(group.getAdditionalPath())) continue;
            return group;
        }
        return null;
    }

    default public Set<HealthEndpointGroup> getAllWithAdditionalPath(WebServerNamespace namespace) {
        Assert.notNull((Object)namespace, (String)"'namespace' must not be null");
        LinkedHashSet<HealthEndpointGroup> filteredGroups = new LinkedHashSet<HealthEndpointGroup>();
        this.getNames().stream().map(this::get).filter(group -> group != null && group.getAdditionalPath() != null && group.getAdditionalPath().hasNamespace(namespace)).forEach(filteredGroups::add);
        return filteredGroups;
    }

    public static HealthEndpointGroups of(final HealthEndpointGroup primary, final Map<String, HealthEndpointGroup> additional) {
        Assert.notNull((Object)primary, (String)"'primary' must not be null");
        Assert.notNull(additional, (String)"'additional' must not be null");
        return new HealthEndpointGroups(){

            @Override
            public HealthEndpointGroup getPrimary() {
                return primary;
            }

            @Override
            public Set<String> getNames() {
                return additional.keySet();
            }

            @Override
            public @Nullable HealthEndpointGroup get(String name) {
                return (HealthEndpointGroup)additional.get(name);
            }
        };
    }
}

