/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;

class CompositeReactiveHealthContributors
implements ReactiveHealthContributors {
    private final List<ReactiveHealthContributors> contributors;

    CompositeReactiveHealthContributors(ReactiveHealthContributors ... contributors) {
        this.contributors = List.of(contributors);
    }

    @Override
    public @Nullable ReactiveHealthContributor getContributor(String name) {
        return this.contributors.stream().map(reactiveContributors -> reactiveContributors.getContributor(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public Stream<ReactiveHealthContributors.Entry> stream() {
        HashSet seen = new HashSet();
        return this.contributors.stream().flatMap(ReactiveHealthContributors::stream).filter(element -> seen.add(element.name()));
    }
}

