/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import jakarta.validation.constraints.Max;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;

@ConfigurationProperties(value="spring.cloud.gateway.httpclient")
@Validated
public class HttpClientProperties {
    private Integer connectTimeout;
    private Duration responseTimeout;
    private DataSize maxHeaderSize;
    private DataSize maxInitialLineLength;
    private Pool pool = new Pool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();
    private Websocket websocket = new Websocket();
    private boolean wiretap;
    private boolean compression;

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    @Max(value=0x7FFFFFFFL)
    public @Max(value=0x7FFFFFFFL) DataSize getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxHeaderSize(DataSize maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    @Max(value=0x7FFFFFFFL)
    public @Max(value=0x7FFFFFFFL) DataSize getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public void setMaxInitialLineLength(DataSize maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Websocket getWebsocket() {
        return this.websocket;
    }

    public void setWebsocket(Websocket websocket) {
        this.websocket = websocket;
    }

    public boolean isWiretap() {
        return this.wiretap;
    }

    public void setWiretap(boolean wiretap) {
        this.wiretap = wiretap;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("connectTimeout", (Object)this.connectTimeout).append("responseTimeout", (Object)this.responseTimeout).append("maxHeaderSize", (Object)this.maxHeaderSize).append("maxInitialLineLength", (Object)this.maxInitialLineLength).append("pool", (Object)this.pool).append("proxy", (Object)this.proxy).append("ssl", (Object)this.ssl).append("websocket", (Object)this.websocket).append("wiretap", this.wiretap).append("compression", this.compression).toString();
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "proxy";
        private Integer maxConnections = ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS;
        private Long acquireTimeout = ConnectionProvider.DEFAULT_POOL_ACQUIRE_TIMEOUT;
        private Duration maxIdleTime = null;
        private Duration maxLifeTime = null;
        private Duration evictionInterval = Duration.ZERO;
        private boolean metrics = false;
        private LeasingStrategy leasingStrategy = LeasingStrategy.FIFO;

        public PoolType getType() {
            return this.type;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        public void setMaxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        public Duration getMaxLifeTime() {
            return this.maxLifeTime;
        }

        public void setMaxLifeTime(Duration maxLifeTime) {
            this.maxLifeTime = maxLifeTime;
        }

        public Duration getEvictionInterval() {
            return this.evictionInterval;
        }

        public void setEvictionInterval(Duration evictionInterval) {
            this.evictionInterval = evictionInterval;
        }

        public boolean isMetrics() {
            return this.metrics;
        }

        public void setMetrics(boolean metrics) {
            this.metrics = metrics;
        }

        public LeasingStrategy getLeasingStrategy() {
            return this.leasingStrategy;
        }

        public void setLeasingStrategy(LeasingStrategy leasingStrategy) {
            this.leasingStrategy = leasingStrategy;
        }

        public String toString() {
            return "Pool{type=" + this.type + ", name='" + this.name + "', maxConnections=" + this.maxConnections + ", acquireTimeout=" + this.acquireTimeout + ", maxIdleTime=" + this.maxIdleTime + ", maxLifeTime=" + this.maxLifeTime + ", evictionInterval=" + this.evictionInterval + ", metrics=" + this.metrics + ", leasingStrategy=" + this.leasingStrategy + "}";
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }

        public static enum LeasingStrategy {
            FIFO,
            LIFO;

        }
    }

    public static class Proxy {
        private ProxyProvider.Proxy type = ProxyProvider.Proxy.HTTP;
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public ProxyProvider.Proxy getType() {
            return this.type;
        }

        public void setType(ProxyProvider.Proxy type) {
            this.type = type;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }

        public String toString() {
            return "Proxy{type='" + this.type + "'host='" + this.host + "', port=" + this.port + ", username='" + this.username + "', password='" + this.password + "', nonProxyHostsPattern='" + this.nonProxyHostsPattern + "'}";
        }
    }

    public static class Ssl {
        private boolean useInsecureTrustManager = false;
        private List<String> trustedX509Certificates = new ArrayList<String>();
        private String sslBundle;
        private Duration handshakeTimeout = Duration.ofMillis(10000L);
        private Duration closeNotifyFlushTimeout = Duration.ofMillis(3000L);
        private Duration closeNotifyReadTimeout = Duration.ZERO;
        private String keyStore;
        private String keyStoreType = "JKS";
        private String keyStoreProvider;
        private String keyStorePassword;
        private String keyPassword;

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public String getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public List<String> getTrustedX509Certificates() {
            return this.trustedX509Certificates;
        }

        public void setTrustedX509Certificates(List<String> trustedX509) {
            this.trustedX509Certificates = trustedX509;
        }

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public Duration getHandshakeTimeout() {
            return this.handshakeTimeout;
        }

        public void setHandshakeTimeout(Duration handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
        }

        public Duration getCloseNotifyFlushTimeout() {
            return this.closeNotifyFlushTimeout;
        }

        public void setCloseNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            this.closeNotifyFlushTimeout = closeNotifyFlushTimeout;
        }

        public Duration getCloseNotifyReadTimeout() {
            return this.closeNotifyReadTimeout;
        }

        public void setCloseNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            this.closeNotifyReadTimeout = closeNotifyReadTimeout;
        }

        public String getSslBundle() {
            return this.sslBundle;
        }

        public void setSslBundle(String sslBundle) {
            this.sslBundle = sslBundle;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("useInsecureTrustManager", this.useInsecureTrustManager).append("trustedX509Certificates", this.trustedX509Certificates).append("handshakeTimeout", (Object)this.handshakeTimeout).append("closeNotifyFlushTimeout", (Object)this.closeNotifyFlushTimeout).append("closeNotifyReadTimeout", (Object)this.closeNotifyReadTimeout).toString();
        }
    }

    public static class Websocket {
        private Integer maxFramePayloadLength;
        private boolean proxyPing = true;

        public Integer getMaxFramePayloadLength() {
            return this.maxFramePayloadLength;
        }

        public void setMaxFramePayloadLength(Integer maxFramePayloadLength) {
            this.maxFramePayloadLength = maxFramePayloadLength;
        }

        public boolean isProxyPing() {
            return this.proxyPing;
        }

        public void setProxyPing(boolean proxyPing) {
            this.proxyPing = proxyPing;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("maxFramePayloadLength", (Object)this.maxFramePayloadLength).append("proxyPing", this.proxyPing).toString();
        }
    }
}

