/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.ArrayList;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpCookie;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class LoadBalancerServiceInstanceCookieFilter
implements GlobalFilter,
Ordered {
    private LoadBalancerProperties loadBalancerProperties;
    private ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory;

    LoadBalancerServiceInstanceCookieFilter(LoadBalancerProperties loadBalancerProperties) {
        this.loadBalancerProperties = loadBalancerProperties;
    }

    public LoadBalancerServiceInstanceCookieFilter(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        LoadBalancerProperties properties;
        Response serviceInstanceResponse = (Response)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_LOADBALANCER_RESPONSE_ATTR);
        if (serviceInstanceResponse == null || !serviceInstanceResponse.hasServer()) {
            return chain.filter(exchange);
        }
        LoadBalancerProperties loadBalancerProperties = properties = this.loadBalancerClientFactory != null ? this.loadBalancerClientFactory.getProperties(((ServiceInstance)serviceInstanceResponse.getServer()).getServiceId()) : this.loadBalancerProperties;
        if (!properties.getStickySession().isAddServiceInstanceCookie()) {
            return chain.filter(exchange);
        }
        String instanceIdCookieName = properties.getStickySession().getInstanceIdCookieName();
        if (!StringUtils.hasText((String)instanceIdCookieName)) {
            return chain.filter(exchange);
        }
        ServerWebExchange newExchange = exchange.mutate().request(exchange.getRequest().mutate().headers(headers -> {
            ArrayList<String> cookieHeaders = new ArrayList<String>(headers.getOrEmpty((Object)"Cookie"));
            String serviceInstanceCookie = new HttpCookie(instanceIdCookieName, ((ServiceInstance)serviceInstanceResponse.getServer()).getInstanceId()).toString();
            cookieHeaders.add(serviceInstanceCookie);
            headers.put("Cookie", cookieHeaders);
        }).build()).build();
        return chain.filter(newExchange);
    }

    public int getOrder() {
        return 10151;
    }
}

