/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RewriteRequestParameterGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String REPLACEMENT_KEY = "replacement";

    public RewriteRequestParameterGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", REPLACEMENT_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ServerHttpRequest req = exchange.getRequest();
                UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)req.getURI());
                LinkedMultiValueMap queryParams = new LinkedMultiValueMap((Map)req.getQueryParams());
                if (queryParams.containsKey((Object)config.getName())) {
                    queryParams.remove((Object)config.getName());
                    queryParams.add((Object)config.getName(), (Object)config.getReplacement());
                }
                try {
                    MultiValueMap<String, String> encodedQueryParams = ServerWebExchangeUtils.encodeQueryParams((MultiValueMap<String, String>)queryParams);
                    URI uri = uriComponentsBuilder.replaceQueryParams(CollectionUtils.unmodifiableMultiValueMap(encodedQueryParams)).build(true).toUri();
                    ServerHttpRequest request = req.mutate().uri(uri).build();
                    return chain.filter(exchange.mutate().request(request).build());
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException("Invalid URI query: \"" + (MultiValueMap)queryParams + "\"");
                }
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(RewriteRequestParameterGatewayFilterFactory.this).append(config.getName(), (Object)config.replacement).toString();
            }
        };
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private String replacement;

        public String getReplacement() {
            return this.replacement;
        }

        public Config setReplacement(String replacement) {
            Assert.notNull((Object)replacement, (String)"replacement must not be null");
            this.replacement = replacement;
            return this;
        }
    }
}

