/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;

public final class CachedResponse
implements Serializable {
    private HttpStatusCode statusCode;
    private HttpHeaders headers;
    private List<ByteBuffer> body;
    private Date timestamp;

    private CachedResponse(HttpStatusCode statusCode, HttpHeaders headers, List<ByteBuffer> body, Date timestamp) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
        this.timestamp = timestamp;
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        this.statusCode = (HttpStatusCode)aInputStream.readObject();
        this.headers = (HttpHeaders)aInputStream.readObject();
        this.body = List.of(ByteBuffer.wrap(aInputStream.readAllBytes()).asReadOnlyBuffer());
        this.timestamp = (Date)aInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.writeObject(this.statusCode);
        aOutputStream.writeObject(this.headers);
        aOutputStream.write(this.bodyAsByteArray());
        aOutputStream.writeObject(this.timestamp);
    }

    public static Builder create(HttpStatusCode statusCode) {
        return new Builder(statusCode);
    }

    public HttpStatusCode statusCode() {
        return this.statusCode;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public List<ByteBuffer> body() {
        return Collections.unmodifiableList(this.body);
    }

    public Date timestamp() {
        return this.timestamp;
    }

    byte[] bodyAsByteArray() throws IOException {
        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(bodyStream);
        for (ByteBuffer byteBuffer : this.body()) {
            channel.write(byteBuffer);
        }
        return bodyStream.toByteArray();
    }

    String bodyAsString() throws IOException {
        InputStream byteStream = new ByteArrayInputStream(this.bodyAsByteArray());
        if (this.headers.getOrEmpty((Object)"Content-Encoding").contains("gzip")) {
            byteStream = new GZIPInputStream(byteStream);
        }
        return new String(FileCopyUtils.copyToByteArray((InputStream)byteStream));
    }

    public static class Builder {
        private final HttpStatusCode statusCode;
        private final HttpHeaders headers = new HttpHeaders();
        private final List<ByteBuffer> body = new ArrayList<ByteBuffer>();
        private Instant timestamp;

        public Builder(HttpStatusCode statusCode) {
            this.statusCode = statusCode;
        }

        public Builder header(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers.addAll((MultiValueMap)headers);
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp.toInstant();
            return this;
        }

        public Builder body(String data) {
            return this.appendToBody(ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8)));
        }

        public Builder appendToBody(ByteBuffer byteBuffer) {
            this.body.add(byteBuffer);
            return this;
        }

        public CachedResponse build() {
            return new CachedResponse(this.statusCode, this.headers, this.body, this.timestamp == null ? new Date() : Date.from(this.timestamp));
        }
    }
}

