/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.config;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.elasticsearch.repository.ReactiveElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.config.ElasticsearchRepositoryConfigExtension;
import org.springframework.data.elasticsearch.repository.support.ReactiveElasticsearchRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class ReactiveElasticsearchRepositoryConfigurationExtension
extends ElasticsearchRepositoryConfigExtension {
    private static final String ELASTICSEARCH_TEMPLATE_REF = "reactive-elasticsearch-template-ref";
    private static final String MODULE_NAME = "Reactive Elasticsearch";

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getRepositoryFactoryClassName() {
        return ReactiveElasticsearchRepositoryFactoryBean.class.getName();
    }

    @Override
    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(ReactiveElasticsearchRepository.class);
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)ELASTICSEARCH_TEMPLATE_REF, (String)"reactiveElasticsearchOperations");
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("reactiveElasticsearchOperations", attributes.getString("reactiveElasticsearchTemplateRef"));
    }

    @Override
    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }
}

