/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import java.time.Duration;
import java.util.function.Consumer;
import org.springframework.http.ResponseCookie;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.MultiValueMap;

public abstract class AbstractCookieAssertions<E, R> {
    private final E exchangeResult;
    private final R responseSpec;

    protected AbstractCookieAssertions(E exchangeResult, R responseSpec) {
        this.exchangeResult = exchangeResult;
        this.responseSpec = responseSpec;
    }

    protected E getExchangeResult() {
        return this.exchangeResult;
    }

    protected R getResponseSpec() {
        return this.responseSpec;
    }

    protected abstract MultiValueMap<String, ResponseCookie> getResponseCookies();

    protected abstract void assertWithDiagnostics(Runnable var1);

    public R valueEquals(String name, String value) {
        ResponseCookie cookie = this.getCookie(name);
        String cookieValue = cookie.getValue();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            AssertionErrors.assertEquals(message, value, cookieValue);
        });
        return this.responseSpec;
    }

    public R value(String name, Consumer<String> consumer) {
        String value = this.getCookie(name).getValue();
        this.assertWithDiagnostics(() -> consumer.accept(value));
        return this.responseSpec;
    }

    public R exists(String name) {
        this.getCookie(name);
        return this.responseSpec;
    }

    public R doesNotExist(String name) {
        ResponseCookie cookie = (ResponseCookie)this.getResponseCookies().getFirst((Object)name);
        if (cookie != null) {
            String message = this.getMessage(name) + " exists with value=[" + cookie.getValue() + "]";
            this.assertWithDiagnostics(() -> AssertionErrors.fail(message));
        }
        return this.responseSpec;
    }

    public R maxAge(String name, Duration expected) {
        Duration maxAge = this.getCookie(name).getMaxAge();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " maxAge";
            AssertionErrors.assertEquals(message, expected, maxAge);
        });
        return this.responseSpec;
    }

    public R maxAge(String name, Consumer<Long> consumer) {
        long maxAge = this.getCookie(name).getMaxAge().getSeconds();
        this.assertWithDiagnostics(() -> consumer.accept(maxAge));
        return this.responseSpec;
    }

    public R path(String name, String expected) {
        String path = this.getCookie(name).getPath();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " path";
            AssertionErrors.assertEquals(message, expected, path);
        });
        return this.responseSpec;
    }

    public R path(String name, Consumer<String> consumer) {
        String path = this.getCookie(name).getPath();
        this.assertWithDiagnostics(() -> consumer.accept(path));
        return this.responseSpec;
    }

    public R domain(String name, String expected) {
        String path = this.getCookie(name).getDomain();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " domain";
            AssertionErrors.assertEquals(message, expected, path);
        });
        return this.responseSpec;
    }

    public R domain(String name, Consumer<String> consumer) {
        String domain = this.getCookie(name).getDomain();
        this.assertWithDiagnostics(() -> consumer.accept(domain));
        return this.responseSpec;
    }

    public R secure(String name, boolean expected) {
        boolean isSecure = this.getCookie(name).isSecure();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " secure";
            AssertionErrors.assertEquals(message, expected, isSecure);
        });
        return this.responseSpec;
    }

    public R httpOnly(String name, boolean expected) {
        boolean isHttpOnly = this.getCookie(name).isHttpOnly();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " httpOnly";
            AssertionErrors.assertEquals(message, expected, isHttpOnly);
        });
        return this.responseSpec;
    }

    public R partitioned(String name, boolean expected) {
        boolean isPartitioned = this.getCookie(name).isPartitioned();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " isPartitioned";
            AssertionErrors.assertEquals(message, expected, isPartitioned);
        });
        return this.responseSpec;
    }

    public R sameSite(String name, String expected) {
        String sameSite = this.getCookie(name).getSameSite();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " sameSite";
            AssertionErrors.assertEquals(message, expected, sameSite);
        });
        return this.responseSpec;
    }

    protected ResponseCookie getCookie(String name) {
        ResponseCookie cookie = (ResponseCookie)this.getResponseCookies().getFirst((Object)name);
        if (cookie != null) {
            return cookie;
        }
        this.assertWithDiagnostics(() -> AssertionErrors.fail("No cookie with name '" + name + "'"));
        throw new IllegalStateException("This code path should not be reachable");
    }

    protected String getMessage(String cookie) {
        return "Response cookie '" + cookie + "'";
    }
}

