/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseExternalData;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.ConfigurableApi;
import ru.yandex.clickhouse.Jackson;
import ru.yandex.clickhouse.LZ4EntityWrapper;
import ru.yandex.clickhouse.Writer;
import ru.yandex.clickhouse.domain.ClickHouseCompression;
import ru.yandex.clickhouse.domain.ClickHouseFormat;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.except.ClickHouseExceptionSpecifier;
import ru.yandex.clickhouse.jdbc.internal.apache.http.Header;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpEntity;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.NameValuePair;
import ru.yandex.clickhouse.jdbc.internal.apache.http.StatusLine;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.methods.HttpGet;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.methods.HttpPost;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.methods.HttpUriRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.protocol.HttpClientContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.utils.URIBuilder;
import ru.yandex.clickhouse.jdbc.internal.apache.http.entity.AbstractHttpEntity;
import ru.yandex.clickhouse.jdbc.internal.apache.http.entity.ContentType;
import ru.yandex.clickhouse.jdbc.internal.apache.http.entity.StringEntity;
import ru.yandex.clickhouse.jdbc.internal.apache.http.entity.mime.MultipartEntityBuilder;
import ru.yandex.clickhouse.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import ru.yandex.clickhouse.jdbc.internal.apache.http.message.BasicNameValuePair;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.EntityUtils;
import ru.yandex.clickhouse.jdbc.internal.slf4j.Logger;
import ru.yandex.clickhouse.jdbc.internal.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbc.parser.ClickHouseSqlParser;
import ru.yandex.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import ru.yandex.clickhouse.jdbc.parser.StatementType;
import ru.yandex.clickhouse.response.ClickHouseLZ4Stream;
import ru.yandex.clickhouse.response.ClickHouseResponse;
import ru.yandex.clickhouse.response.ClickHouseResponseSummary;
import ru.yandex.clickhouse.response.ClickHouseResultSet;
import ru.yandex.clickhouse.response.ClickHouseScrollableResultSet;
import ru.yandex.clickhouse.response.FastByteArrayOutputStream;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.ClickHouseHttpClientBuilder;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryInputStream;
import ru.yandex.clickhouse.util.ClickHouseStreamCallback;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseStatementImpl
extends ConfigurableApi<ClickHouseStatement>
implements ClickHouseStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    private final CloseableHttpClient client;
    private final HttpClientContext httpContext;
    protected ClickHouseProperties properties;
    private ClickHouseConnection connection;
    private ClickHouseResultSet currentResult;
    private ClickHouseRowBinaryInputStream currentRowBinaryResult;
    private ClickHouseResponseSummary currentSummary;
    private int currentUpdateCount = -1;
    private int queryTimeout;
    private boolean isQueryTimeoutSet = false;
    private int maxRows;
    private boolean closeOnCompletion;
    private final boolean isResultSetScrollable;
    private volatile String queryId;
    protected ClickHouseSqlStatement[] parsedStmts;
    protected List<ClickHouseSqlStatement> batchStmts;
    protected String currentDatabase;

    protected ClickHouseSqlStatement getLastStatement() {
        ClickHouseSqlStatement stmt = null;
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            stmt = this.parsedStmts[this.parsedStmts.length - 1];
        }
        return Objects.requireNonNull(stmt);
    }

    protected void setLastStatement(ClickHouseSqlStatement stmt) {
        if (this.parsedStmts != null && this.parsedStmts.length > 0) {
            this.parsedStmts[this.parsedStmts.length - 1] = Objects.requireNonNull(stmt);
        }
    }

    protected ClickHouseSqlStatement[] parseSqlStatements(String sql) throws SQLException {
        this.parsedStmts = ClickHouseSqlParser.parse(sql, this.properties);
        if (this.parsedStmts == null || this.parsedStmts.length == 0) {
            throw new IllegalArgumentException("Failed to parse given SQL: " + sql);
        }
        return this.parsedStmts;
    }

    protected ClickHouseSqlStatement parseSqlStatements(String sql, ClickHouseFormat preferredFormat, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        ClickHouseSqlStatement lastStmt;
        ClickHouseSqlStatement formattedStmt;
        this.parseSqlStatements(sql);
        if (additionalDBParams != null && this.parsedStmts.length > 1 && this.properties.getSessionId() == null) {
            additionalDBParams.put(ClickHouseQueryParam.SESSION_ID, UUID.randomUUID().toString());
        }
        if ((formattedStmt = this.applyFormat(lastStmt = this.getLastStatement(), preferredFormat)) != lastStmt) {
            lastStmt = formattedStmt;
            this.setLastStatement(lastStmt);
        }
        return lastStmt;
    }

    protected ClickHouseSqlStatement applyFormat(ClickHouseSqlStatement stmt, ClickHouseFormat preferredFormat) {
        if (Objects.requireNonNull(stmt).isQuery() && !stmt.hasFormat()) {
            String sql = stmt.getSQL();
            String format = Objects.requireNonNull(preferredFormat).name();
            HashMap<String, Integer> positions = new HashMap<String, Integer>();
            positions.putAll(stmt.getPositions());
            positions.put("FORMAT", sql.length());
            sql = sql + "\nFORMAT " + format;
            stmt = new ClickHouseSqlStatement(sql, stmt.getStatementType(), stmt.getCluster(), stmt.getDatabase(), stmt.getTable(), format, stmt.getOutfile(), stmt.getParameters(), positions);
        }
        return stmt;
    }

    protected Map<ClickHouseQueryParam, String> importAdditionalDBParameters(Map<ClickHouseQueryParam, String> additionalDBParams) {
        additionalDBParams = additionalDBParams == null || additionalDBParams.isEmpty() ? new EnumMap<ClickHouseQueryParam, String>(ClickHouseQueryParam.class) : new EnumMap<ClickHouseQueryParam, String>(additionalDBParams);
        return additionalDBParams;
    }

    protected ResultSet updateResult(ClickHouseSqlStatement stmt, InputStream is) throws IOException, ClickHouseException {
        ClickHouseResultSet rs = null;
        if (stmt.isQuery()) {
            this.currentUpdateCount = -1;
            this.currentResult = this.createResultSet(this.properties.isCompress() ? new ClickHouseLZ4Stream(is) : is, this.properties.getBufferSize(), stmt.getDatabaseOrDefault(this.properties.getDatabase()), stmt.getTable(), stmt.hasWithTotals(), this, this.getConnection().getTimeZone(), this.properties);
            this.currentResult.setMaxRows(this.maxRows);
            rs = this.currentResult;
        } else {
            this.currentUpdateCount = 0;
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("can not close stream: {}", (Object)e.getMessage());
            }
        }
        return rs;
    }

    protected int executeStatement(ClickHouseSqlStatement stmt, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        stmt = this.applyFormat(stmt, ClickHouseFormat.TabSeparatedWithNamesAndTypes);
        try {
            InputStream is = this.getInputStream(stmt, additionalDBParams, externalData, additionalRequestParams);
            Throwable throwable = null;
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.error("can not close stream: {}", (Object)e.getMessage());
        }
        return this.currentSummary != null ? (int)this.currentSummary.getWrittenRows() : 1;
    }

    protected ResultSet executeQueryStatement(ClickHouseSqlStatement stmt, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        stmt = this.applyFormat(stmt, ClickHouseFormat.TabSeparatedWithNamesAndTypes);
        InputStream is = this.getInputStream(stmt, additionalDBParams, externalData, additionalRequestParams);
        try {
            return this.updateResult(stmt, is);
        }
        catch (Exception e) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                log.error("can not close stream: {}", (Object)ioe.getMessage());
            }
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClickHouseResponse executeQueryClickhouseResponse(ClickHouseSqlStatement stmt, Map<ClickHouseQueryParam, String> additionalDBParams, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        stmt = this.applyFormat(stmt, ClickHouseFormat.JSONCompact);
        try (InputStream is = this.getInputStream(stmt, additionalDBParams, null, additionalRequestParams);){
            ClickHouseResponse clickHouseResponse = Jackson.getObjectMapper().readValue(this.properties.isCompress() ? new ClickHouseLZ4Stream(is) : is, ClickHouseResponse.class);
            return clickHouseResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClickHouseStatementImpl(CloseableHttpClient client, ClickHouseConnection connection, ClickHouseProperties properties, int resultSetType) {
        super(null);
        this.client = client;
        this.httpContext = ClickHouseHttpClientBuilder.createClientContext(properties);
        this.connection = connection;
        this.properties = properties == null ? new ClickHouseProperties() : properties;
        this.currentDatabase = this.properties.getDatabase();
        this.isResultSetScrollable = resultSetType != 1003;
        this.batchStmts = new ArrayList<ClickHouseSqlStatement>();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQuery(sql, additionalDBParams, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        return this.executeQuery(sql, additionalDBParams, externalData, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        additionalDBParams.put(ClickHouseQueryParam.EXTREMES, "0");
        this.parseSqlStatements(sql, ClickHouseFormat.TabSeparatedWithNamesAndTypes, additionalDBParams);
        InputStream is = this.getLastInputStream(additionalDBParams, externalData, additionalRequestParams);
        ClickHouseSqlStatement parsedStmt = this.getLastStatement();
        try {
            return this.updateResult(parsedStmt, is);
        }
        catch (Exception e) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                log.error("can not close stream: {}", (Object)ioe.getMessage());
            }
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(String sql) throws SQLException {
        return this.executeQueryClickhouseResponse(sql, null);
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQueryClickhouseResponse(sql, additionalDBParams, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        this.parseSqlStatements(sql, ClickHouseFormat.JSONCompact, additionalDBParams);
        try (InputStream is = this.getLastInputStream(additionalDBParams, null, additionalRequestParams);){
            ClickHouseResponse clickHouseResponse = Jackson.getObjectMapper().readValue(this.properties.isCompress() ? new ClickHouseLZ4Stream(is) : is, ClickHouseResponse.class);
            return clickHouseResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql) throws SQLException {
        return this.executeQueryClickhouseRowBinaryStream(sql, null);
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQueryClickhouseRowBinaryStream(sql, additionalDBParams, null);
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, Map<String, String> additionalRequestParams) throws SQLException {
        additionalDBParams = this.importAdditionalDBParameters(additionalDBParams);
        this.parseSqlStatements(sql, ClickHouseFormat.RowBinaryWithNamesAndTypes, additionalDBParams);
        InputStream is = this.getLastInputStream(additionalDBParams, null, additionalRequestParams);
        ClickHouseSqlStatement parsedStmt = this.getLastStatement();
        try {
            if (parsedStmt.isQuery()) {
                this.currentUpdateCount = -1;
                this.currentRowBinaryResult = new ClickHouseRowBinaryInputStream(this.properties.isCompress() ? new ClickHouseLZ4Stream(is) : is, this.getConnection().getTimeZone(), this.properties, true);
                return this.currentRowBinaryResult;
            }
            this.currentUpdateCount = 0;
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("can not close stream: {}", (Object)e.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                log.error("can not close stream: {}", (Object)ioe.getMessage());
            }
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        EnumMap<ClickHouseQueryParam, String> additionalDBParams = new EnumMap<ClickHouseQueryParam, String>(ClickHouseQueryParam.class);
        this.parseSqlStatements(sql, ClickHouseFormat.TabSeparatedWithNamesAndTypes, additionalDBParams);
        try {
            InputStream is = this.getLastInputStream(additionalDBParams, null, null);
            Throwable throwable = null;
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.error("can not close stream: {}", (Object)e.getMessage());
        }
        return this.currentSummary != null ? (int)this.currentSummary.getWrittenRows() : 1;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        if (this.currentRowBinaryResult != null) {
            try {
                this.currentRowBinaryResult.close();
            }
            catch (IOException e) {
                log.error("can not close stream: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException(String.format("Illegal maxRows value: %d", max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
        this.isQueryTimeoutSet = true;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.queryId == null || this.isClosed()) {
            return;
        }
        this.executeQuery(String.format("KILL QUERY WHERE query_id='%s'", this.queryId));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        this.currentUpdateCount = -1;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        for (ClickHouseSqlStatement s : ClickHouseSqlParser.parse(sql, this.properties)) {
            this.batchStmts.add(s);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchStmts = new ArrayList<ClickHouseSqlStatement>();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int len = this.batchStmts.size();
        int[] results = new int[len];
        for (int i = 0; i < len; ++i) {
            results[i] = this.executeStatement(this.batchStmts.get(i), null, null, null);
        }
        this.clearBatch();
        return results;
    }

    @Override
    public ClickHouseConnection getConnection() throws ClickHouseException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public ClickHouseResponseSummary getResponseSummary() {
        return this.currentSummary;
    }

    private InputStream getLastInputStream(Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws ClickHouseException {
        InputStream is = null;
        int len = this.parsedStmts.length;
        for (int i = 0; i < len; ++i) {
            is = this.getInputStream(this.parsedStmts[i], additionalDBParams, externalData, additionalRequestParams);
            if (i + 1 >= len) continue;
            try {
                is.close();
                continue;
            }
            catch (IOException ioe) {
                log.warn("Failed to close stream: {}", (Object)ioe.getMessage());
            }
        }
        return is;
    }

    private InputStream getInputStream(ClickHouseSqlStatement parsedStmt, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws ClickHouseException {
        HttpEntity requestEntity;
        boolean ignoreDatabase;
        String sql = parsedStmt.getSQL();
        boolean bl = ignoreDatabase = parsedStmt.isRecognized() && !parsedStmt.isDML() && parsedStmt.containsKeyword("DATABASE");
        if (parsedStmt.getStatementType() == StatementType.USE) {
            this.currentDatabase = parsedStmt.getDatabaseOrDefault(this.currentDatabase);
        }
        log.debug("Executing SQL: {}", (Object)sql);
        additionalClickHouseDBParams = this.addQueryIdTo((Map<ClickHouseQueryParam, String>)(additionalClickHouseDBParams == null ? new EnumMap(ClickHouseQueryParam.class) : additionalClickHouseDBParams));
        URI uri = this.buildRequestUri(null, externalData, additionalClickHouseDBParams, additionalRequestParams, ignoreDatabase);
        log.debug("Request url: {}", (Object)uri);
        if (externalData == null || externalData.isEmpty()) {
            requestEntity = new StringEntity(sql, StandardCharsets.UTF_8);
        } else {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.addTextBody("query", sql);
            try {
                for (ClickHouseExternalData externalDataItem : externalData) {
                    entityBuilder.addBinaryBody(externalDataItem.getName(), Utils.toByteArray(externalDataItem.getContent()), ContentType.APPLICATION_OCTET_STREAM, externalDataItem.getName());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            requestEntity = entityBuilder.build();
        }
        requestEntity = this.applyRequestBodyCompression(requestEntity);
        HttpEntity entity = null;
        try {
            InputStream is;
            uri = this.followRedirects(uri);
            HttpPost post = new HttpPost(uri);
            post.setEntity(requestEntity);
            if (parsedStmt.isIdemponent()) {
                this.httpContext.setAttribute("is_idempotent", Boolean.TRUE);
            } else {
                this.httpContext.removeAttribute("is_idempotent");
            }
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, this.httpContext);
            entity = response.getEntity();
            this.checkForErrorAndThrow(entity, response);
            if (entity.isStreaming()) {
                is = entity.getContent();
            } else {
                FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
                entity.writeTo(baos);
                is = baos.convertToInputStream();
            }
            if (this.isQueryParamSet(ClickHouseQueryParam.SEND_PROGRESS_IN_HTTP_HEADERS, additionalClickHouseDBParams, additionalRequestParams)) {
                Header summaryHeader = response.getFirstHeader("X-ClickHouse-Summary");
                this.currentSummary = summaryHeader != null ? Jackson.getObjectMapper().readValue(summaryHeader.getValue(), ClickHouseResponseSummary.class) : null;
            }
            return is;
        }
        catch (ClickHouseException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("Error during connection to {}, reporting failure to data source, message: {}", (Object)this.properties, (Object)e.getMessage());
            EntityUtils.consumeQuietly(entity);
            log.info("Error sql: {}", (Object)sql);
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    URI buildRequestUri(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams, boolean ignoreDatabase) {
        try {
            List<NameValuePair> queryParams = this.getUrlQueryParams(sql, externalData, additionalClickHouseDBParams, additionalRequestParams, ignoreDatabase);
            if (additionalClickHouseDBParams != null) {
                additionalClickHouseDBParams.remove(ClickHouseQueryParam.QUERY_ID);
            }
            return new URIBuilder().setScheme(this.properties.getSsl() ? "https" : "http").setHost(this.properties.getHost()).setPort(this.properties.getPort()).setPath(this.properties.getPath() == null || this.properties.getPath().isEmpty() ? "/" : this.properties.getPath()).setParameters(queryParams).build();
        }
        catch (URISyntaxException e) {
            log.error("Mailformed URL: {}", (Object)e.getMessage());
            throw new IllegalStateException("illegal configuration of db");
        }
    }

    private List<NameValuePair> getUrlQueryParams(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams, boolean ignoreDatabase) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (sql != null && !sql.isEmpty()) {
            result.add(new BasicNameValuePair("query", sql));
        }
        if (externalData != null) {
            for (ClickHouseExternalData externalDataItem : externalData) {
                String string = externalDataItem.getName();
                String format = externalDataItem.getFormat();
                String types = externalDataItem.getTypes();
                String structure = externalDataItem.getStructure();
                if (format != null && !format.isEmpty()) {
                    result.add(new BasicNameValuePair(string + "_format", format));
                }
                if (types != null && !types.isEmpty()) {
                    result.add(new BasicNameValuePair(string + "_types", types));
                }
                if (structure == null || structure.isEmpty()) continue;
                result.add(new BasicNameValuePair(string + "_structure", structure));
            }
        }
        Map<ClickHouseQueryParam, String> params = this.properties.buildQueryParams(true);
        if (!ignoreDatabase) {
            params.put(ClickHouseQueryParam.DATABASE, this.currentDatabase);
        }
        params.putAll(this.getAdditionalDBParams());
        if (additionalClickHouseDBParams != null && !additionalClickHouseDBParams.isEmpty()) {
            params.putAll(additionalClickHouseDBParams);
        }
        this.setStatementPropertiesToParams(params);
        for (Map.Entry<ClickHouseQueryParam, String> entry : params.entrySet()) {
            if (Utils.isNullOrEmptyString(entry.getValue())) continue;
            result.add(new BasicNameValuePair(entry.getKey().toString(), entry.getValue()));
        }
        for (Map.Entry<Object, String> entry : this.getRequestParams().entrySet()) {
            if (Utils.isNullOrEmptyString(entry.getValue())) continue;
            result.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue()));
        }
        if (additionalRequestParams != null) {
            for (Map.Entry<Object, String> entry : additionalRequestParams.entrySet()) {
                if (Utils.isNullOrEmptyString(entry.getValue())) continue;
                result.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    private boolean isQueryParamSet(ClickHouseQueryParam param, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams) {
        String value = this.getQueryParamValue(param, additionalClickHouseDBParams, additionalRequestParams);
        return "true".equals(value) || "1".equals(value);
    }

    private String getQueryParamValue(ClickHouseQueryParam param, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams) {
        if (additionalRequestParams != null && additionalRequestParams.containsKey(param.getKey()) && !Utils.isNullOrEmptyString(additionalRequestParams.get(param.getKey()))) {
            return additionalRequestParams.get(param.getKey());
        }
        if (this.getRequestParams().containsKey(param.getKey()) && !Utils.isNullOrEmptyString(this.getRequestParams().get(param.getKey()))) {
            return this.getRequestParams().get(param.getKey());
        }
        if (additionalClickHouseDBParams != null && additionalClickHouseDBParams.containsKey(param) && !Utils.isNullOrEmptyString(additionalClickHouseDBParams.get(param))) {
            return additionalClickHouseDBParams.get(param);
        }
        if (this.getAdditionalDBParams().containsKey(param) && !Utils.isNullOrEmptyString(this.getAdditionalDBParams().get(param))) {
            return this.getAdditionalDBParams().get(param);
        }
        return this.properties.asProperties().getProperty(param.getKey());
    }

    private URI followRedirects(URI uri) throws IOException, URISyntaxException {
        if (this.properties.isCheckForRedirects()) {
            HttpGet httpGet;
            CloseableHttpResponse response;
            for (int redirects = 0; redirects < this.properties.getMaxRedirects() && (response = this.client.execute((HttpUriRequest)(httpGet = new HttpGet(uri)), this.httpContext)).getStatusLine().getStatusCode() == 307; ++redirects) {
                uri = new URI(response.getHeaders("Location")[0].getValue());
                log.info("Redirected to " + uri.getHost());
            }
        }
        return uri;
    }

    private void setStatementPropertiesToParams(Map<ClickHouseQueryParam, String> params) {
        if (this.maxRows > 0) {
            params.put(ClickHouseQueryParam.MAX_RESULT_ROWS, String.valueOf(this.maxRows));
            params.put(ClickHouseQueryParam.RESULT_OVERFLOW_MODE, "break");
        }
        if (this.isQueryTimeoutSet) {
            params.put(ClickHouseQueryParam.MAX_EXECUTION_TIME, String.valueOf(this.queryTimeout));
        }
    }

    @Override
    public void sendRowBinaryStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendRowBinaryStream(sql, null, callback);
    }

    @Override
    public void sendRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, ClickHouseStreamCallback callback) throws SQLException {
        ((Writer)this.write().withDbParams(additionalDBParams)).send(sql, callback, ClickHouseFormat.RowBinary);
    }

    @Override
    public void sendNativeStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendNativeStream(sql, null, callback);
    }

    @Override
    public void sendNativeStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, ClickHouseStreamCallback callback) throws SQLException {
        ((Writer)this.write().withDbParams(additionalDBParams)).send(sql, callback, ClickHouseFormat.Native);
    }

    @Override
    public void sendCSVStream(InputStream content, String table, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        ((Writer)this.write().table(table).withDbParams(additionalDBParams)).data(content).format(ClickHouseFormat.CSV).send();
    }

    @Override
    public void sendCSVStream(InputStream content, String table) throws SQLException {
        this.sendCSVStream(content, table, null);
    }

    @Override
    public void sendStream(InputStream content, String table) throws SQLException {
        this.sendStream(content, table, null);
    }

    @Override
    public void sendStream(InputStream content, String table, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        ((Writer)this.write().table(table).data(content).withDbParams(additionalDBParams)).format(ClickHouseFormat.TabSeparated).send();
    }

    @Deprecated
    public void sendStream(HttpEntity content, String sql) throws ClickHouseException {
        this.sendStream(content, sql, ClickHouseFormat.TabSeparated, null);
    }

    @Deprecated
    public void sendStream(HttpEntity content, String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws ClickHouseException {
        this.sendStream(content, sql, ClickHouseFormat.TabSeparated, additionalDBParams);
    }

    private void sendStream(HttpEntity content, String sql, ClickHouseFormat format, Map<ClickHouseQueryParam, String> additionalDBParams) throws ClickHouseException {
        Writer writer = ((Writer)this.write().format(format).withDbParams(additionalDBParams)).sql(sql);
        this.sendStream(writer, content);
    }

    @Override
    public void sendStreamSQL(InputStream content, String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        ((Writer)this.write().data(content).sql(sql).withDbParams(additionalDBParams)).send();
    }

    @Override
    public void sendStreamSQL(InputStream content, String sql) throws SQLException {
        this.write().sql(sql).data(content).send();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendStream(Writer writer, HttpEntity content) throws ClickHouseException {
        HttpEntity entity = null;
        try {
            String sql = writer.getSql();
            boolean isContentCompressed = writer.getCompression() != ClickHouseCompression.none;
            URI uri = this.buildRequestUri(isContentCompressed ? sql : null, null, writer.getAdditionalDBParams(), writer.getRequestParams(), false);
            uri = this.followRedirects(uri);
            content = this.applyRequestBodyCompression(new WrappedHttpEntity(isContentCompressed ? null : sql, content));
            HttpPost httpPost = new HttpPost(uri);
            if (writer.getCompression() != ClickHouseCompression.none) {
                httpPost.addHeader("Content-Encoding", writer.getCompression().name());
            }
            httpPost.setEntity(content);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost, this.httpContext);
            entity = response.getEntity();
            this.checkForErrorAndThrow(entity, response);
            if (this.isQueryParamSet(ClickHouseQueryParam.SEND_PROGRESS_IN_HTTP_HEADERS, writer.getAdditionalDBParams(), writer.getRequestParams())) {
                Header summaryHeader = response.getFirstHeader("X-ClickHouse-Summary");
                this.currentSummary = summaryHeader != null ? Jackson.getObjectMapper().readValue(summaryHeader.getValue(), ClickHouseResponseSummary.class) : null;
            }
        }
        catch (ClickHouseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw ClickHouseExceptionSpecifier.specify(e2, this.properties.getHost(), this.properties.getPort());
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(entity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly(entity);
    }

    private void checkForErrorAndThrow(HttpEntity entity, HttpResponse response) throws IOException, ClickHouseException {
        StatusLine line = response.getStatusLine();
        if (line.getStatusCode() != 200) {
            InputStream messageStream = entity.getContent();
            byte[] bytes = Utils.toByteArray(messageStream);
            if (this.properties.isCompress()) {
                try {
                    messageStream = new ClickHouseLZ4Stream(new ByteArrayInputStream(bytes));
                    bytes = Utils.toByteArray(messageStream);
                }
                catch (IOException e) {
                    log.warn("error while read compressed stream {}", (Object)e.getMessage());
                }
            }
            EntityUtils.consumeQuietly(entity);
            if (bytes.length == 0) {
                throw ClickHouseExceptionSpecifier.specify(new IllegalStateException(line.toString()), this.properties.getHost(), this.properties.getPort());
            }
            throw ClickHouseExceptionSpecifier.specify(new String(bytes, StandardCharsets.UTF_8), this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    private HttpEntity applyRequestBodyCompression(HttpEntity entity) {
        if (this.properties.isDecompress()) {
            return new LZ4EntityWrapper(entity, this.properties.getMaxCompressBufferSize());
        }
        return entity;
    }

    private ClickHouseResultSet createResultSet(InputStream is, int bufferSize, String db, String table, boolean usesWithTotals, ClickHouseStatement statement, TimeZone timezone, ClickHouseProperties properties) throws IOException {
        if (this.isResultSetScrollable) {
            return new ClickHouseScrollableResultSet(is, bufferSize, db, table, usesWithTotals, statement, timezone, properties);
        }
        return new ClickHouseResultSet(is, bufferSize, db, table, usesWithTotals, statement, timezone, properties);
    }

    private Map<ClickHouseQueryParam, String> addQueryIdTo(Map<ClickHouseQueryParam, String> parameters) {
        if (this.queryId != null) {
            return parameters;
        }
        String queryId = parameters.get(ClickHouseQueryParam.QUERY_ID);
        if (queryId == null) {
            this.queryId = UUID.randomUUID().toString();
            parameters.put(ClickHouseQueryParam.QUERY_ID, this.queryId);
        } else {
            this.queryId = queryId;
        }
        return parameters;
    }

    @Override
    public Writer write() {
        return (Writer)((Writer)new Writer(this).withDbParams(this.getAdditionalDBParams())).options(this.getRequestParams());
    }

    protected static class WrappedHttpEntity
    extends AbstractHttpEntity {
        private final String sql;
        private final HttpEntity entity;

        public WrappedHttpEntity(String sql, HttpEntity entity) {
            this.sql = sql;
            this.entity = Objects.requireNonNull(entity);
            this.chunked = entity.isChunked();
            this.contentEncoding = entity.getContentEncoding();
            this.contentType = entity.getContentType();
        }

        @Override
        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        @Override
        public long getContentLength() {
            return this.entity.getContentLength();
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return this.entity.getContent();
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            if (this.sql != null && !this.sql.isEmpty()) {
                outputStream.write(this.sql.getBytes(StandardCharsets.UTF_8));
                outputStream.write(10);
            }
            this.entity.writeTo(outputStream);
        }

        @Override
        public boolean isStreaming() {
            return this.entity.isStreaming();
        }
    }
}

