/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.client.protocol;

import java.io.IOException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpEntity;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpEntityEnclosingRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequestInterceptor;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ProtocolVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.config.RequestConfig;
import ru.yandex.clickhouse.jdbc.internal.apache.http.client.protocol.HttpClientContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

