/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.impl;

import java.util.Locale;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponseFactory;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ProtocolVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ReasonPhraseCatalog;
import ru.yandex.clickhouse.jdbc.internal.apache.http.StatusLine;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.impl.EnglishReasonPhraseCatalog;
import ru.yandex.clickhouse.jdbc.internal.apache.http.message.BasicHttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.message.BasicStatusLine;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

