/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.impl.cookie;

import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.cookie.CommonCookieAttributeHandler;
import ru.yandex.clickhouse.jdbc.internal.apache.http.cookie.Cookie;
import ru.yandex.clickhouse.jdbc.internal.apache.http.cookie.CookieOrigin;
import ru.yandex.clickhouse.jdbc.internal.apache.http.cookie.MalformedCookieException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.cookie.SetCookie;
import ru.yandex.clickhouse.jdbc.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

