/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.protocol;

import java.io.IOException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpEntity;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpEntityEnclosingRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequestInterceptor;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ProtocolVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

