/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpConnection;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpHost;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpInetConnection;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequest;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpRequestInterceptor;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ProtocolException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.ProtocolVersion;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpCoreContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

