/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.protocol;

import java.io.IOException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponseInterceptor;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpDateGenerator;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

