/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.apache.http.protocol;

import java.io.IOException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpException;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponse;
import ru.yandex.clickhouse.jdbc.internal.apache.http.HttpResponseInterceptor;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.Contract;
import ru.yandex.clickhouse.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import ru.yandex.clickhouse.jdbc.internal.apache.http.protocol.HttpContext;
import ru.yandex.clickhouse.jdbc.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

