/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.jackson.core.util;

import java.lang.ref.SoftReference;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.io.JsonStringEncoder;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.util.BufferRecycler;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.util.ThreadLocalBufferManager;

public class BufferRecyclers {
    public static final String SYSTEM_PROPERTY_TRACK_REUSABLE_BUFFERS = "ru.yandex.clickhouse.jdbc.internal.jackson.core.util.BufferRecyclers.trackReusableBuffers";
    private static final ThreadLocalBufferManager _bufferRecyclerTracker = "true".equals(System.getProperty("ru.yandex.clickhouse.jdbc.internal.jackson.core.util.BufferRecyclers.trackReusableBuffers")) ? ThreadLocalBufferManager.instance() : null;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _encoderRef = new ThreadLocal();

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            ref = _bufferRecyclerTracker != null ? _bufferRecyclerTracker.wrapAndTrack(br) : new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref);
        }
        return br;
    }

    public static int releaseBuffers() {
        if (_bufferRecyclerTracker != null) {
            return _bufferRecyclerTracker.releaseBuffers();
        }
        return -1;
    }

    public static JsonStringEncoder getJsonStringEncoder() {
        JsonStringEncoder enc;
        SoftReference<JsonStringEncoder> ref = _encoderRef.get();
        JsonStringEncoder jsonStringEncoder = enc = ref == null ? null : ref.get();
        if (enc == null) {
            enc = new JsonStringEncoder();
            _encoderRef.set(new SoftReference<JsonStringEncoder>(enc));
        }
        return enc;
    }

    public static byte[] encodeAsUTF8(String text) {
        return BufferRecyclers.getJsonStringEncoder().encodeAsUTF8(text);
    }

    public static char[] quoteAsJsonText(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsString(rawText);
    }

    public static void quoteAsJsonText(CharSequence input, StringBuilder output) {
        BufferRecyclers.getJsonStringEncoder().quoteAsString(input, output);
    }

    public static byte[] quoteAsJsonUTF8(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsUTF8(rawText);
    }
}

