/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.jackson.databind.ext;

import java.io.IOException;
import java.lang.reflect.Type;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonGenerationException;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JavaType;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonNode;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std.StdSerializer;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final DOMImplementationLS _domImpl;

    public DOMSerializer() {
        super(Node.class);
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate DOMImplementationRegistry: " + e.getMessage(), e);
        }
        this._domImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
    }

    @Override
    public void serialize(Node value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._domImpl == null) {
            throw new IllegalStateException("Could not find DOM LS");
        }
        LSSerializer writer = this._domImpl.createLSSerializer();
        jgen.writeString(writer.writeToString(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(typeHint);
        }
    }
}

