/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Set;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.type.WritableTypeId;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonSerializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.SerializationFeature;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.BeanPropertyWriter;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.impl.ObjectIdWriter;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std.BeanSerializerBase;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.util.NameTransformer;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase src) {
        super(src, (ObjectIdWriter)null);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, Set<String> toIgnore) {
        super(src, toIgnore);
        this._defaultSerializer = src;
    }

    protected BeanAsArraySerializer(BeanSerializerBase src, ObjectIdWriter oiw, Object filterId) {
        super(src, oiw, filterId);
        this._defaultSerializer = src;
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return this._defaultSerializer.unwrappingSerializer(transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanAsArraySerializer withIgnorals(Set<String> toIgnore) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, toIgnore);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, provider, typeSer);
            return;
        }
        gen.setCurrentValue(bean);
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_ARRAY);
        typeSer.writeTypePrefix(gen, typeIdDef);
        this.serializeAsArray(bean, gen, provider);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(provider)) {
            this.serializeAsArray(bean, gen, provider);
            return;
        }
        gen.writeStartArray();
        gen.setCurrentValue(bean);
        this.serializeAsArray(bean, gen, provider);
        gen.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider provider) {
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getActiveView() != null ? this._filteredProps : this._props;
        return props.length == 1;
    }

    protected final void serializeAsArray(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int i;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter prop : props) {
                if (prop == null) {
                    gen.writeNull();
                    continue;
                }
                prop.serializeAsElement(bean, gen, provider);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, (Throwable)e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = JsonMappingException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e);
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
    }

    public String toString() {
        return "BeanAsArraySerializer for " + this.handledType().getName();
    }
}

