/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JavaType;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonNode;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.annotation.JacksonStdImpl;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class StringSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;

    public StringSerializer() {
        super(String.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.length() == 0;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

