/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonGenerator;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonToken;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.type.WritableTypeId;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JavaType;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonNode;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.SerializerProvider;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.annotation.JacksonStdImpl;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

