/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import ru.yandex.clickhouse.Jackson;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonParser;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.JsonProcessingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.core.type.TypeReference;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.DeserializationContext;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonDeserializer;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.JsonMappingException;
import ru.yandex.clickhouse.jdbc.internal.jackson.databind.type.TypeFactory;
import ru.yandex.clickhouse.util.LRUCache;

class ArrayToStringDeserializer
extends JsonDeserializer<List<String>> {
    private static final Map<DeserializationContext, JsonDeserializer<Object>> deserializers = LRUCache.create(1000, new Function<DeserializationContext, JsonDeserializer<Object>>(){

        @Override
        public JsonDeserializer<Object> apply(DeserializationContext ctx) {
            try {
                return ctx.findContextualValueDeserializer(TypeFactory.defaultInstance().constructType(new TypeReference<List<Object>>(){}), null);
            }
            catch (JsonMappingException e) {
                throw new IllegalStateException(e);
            }
        }
    });

    ArrayToStringDeserializer() {
    }

    @Override
    public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonDeserializer<Object> deserializer = deserializers.get(ctxt);
        Object deserialized = deserializer.deserialize(jp, ctxt);
        if (!(deserialized instanceof List)) {
            throw new IllegalStateException();
        }
        List deserializedList = (List)deserialized;
        ArrayList<String> result = new ArrayList<String>();
        for (Object x : deserializedList) {
            String v = null;
            if (x instanceof List) {
                try {
                    v = Jackson.getObjectMapper().writeValueAsString(x);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            } else if (x != null) {
                v = x.toString();
            }
            result.add(v);
        }
        return result;
    }
}

