/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import ru.yandex.clickhouse.jdbc.internal.jpountz.lz4.LZ4Factory;
import ru.yandex.clickhouse.jdbc.internal.jpountz.lz4.LZ4FastDecompressor;
import ru.yandex.clickhouse.util.ClickHouseBlockChecksum;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseLZ4Stream
extends InputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    public static final int MAGIC = 130;
    private final InputStream stream;
    private final DataInputStream dataWrapper;
    private byte[] currentBlock;
    private int pointer;

    public ClickHouseLZ4Stream(InputStream stream) {
        this.stream = stream;
        this.dataWrapper = new DataInputStream(stream);
    }

    @Override
    public int read() throws IOException {
        if (!this.checkNext()) {
            return -1;
        }
        byte b = this.currentBlock[this.pointer];
        ++this.pointer;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.checkNext()) {
            return -1;
        }
        int targetPointer = off;
        for (copied = 0; copied != len; copied += toCopy) {
            toCopy = Math.min(this.currentBlock.length - this.pointer, len - copied);
            System.arraycopy(this.currentBlock, this.pointer, b, targetPointer, toCopy);
            targetPointer += toCopy;
            this.pointer += toCopy;
            if (this.checkNext()) continue;
            return copied;
        }
        return copied;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private boolean checkNext() throws IOException {
        if (this.currentBlock == null || this.pointer == this.currentBlock.length) {
            this.currentBlock = this.readNextBlock();
            this.pointer = 0;
        }
        return this.currentBlock != null;
    }

    private byte[] readNextBlock() throws IOException {
        int read = this.stream.read();
        if (read < 0) {
            return null;
        }
        byte[] checksum = new byte[16];
        checksum[0] = (byte)read;
        Utils.readFully(this.dataWrapper, checksum, 1, 15);
        ClickHouseBlockChecksum expected = ClickHouseBlockChecksum.fromBytes(checksum);
        int magic = this.dataWrapper.readUnsignedByte();
        if (magic != 130) {
            throw new IOException("Magic is not correct: " + magic);
        }
        int compressedSizeWithHeader = Utils.readInt(this.dataWrapper);
        int uncompressedSize = Utils.readInt(this.dataWrapper);
        int compressedSize = compressedSizeWithHeader - 9;
        byte[] block = new byte[compressedSize];
        Utils.readFully(this.dataWrapper, block);
        ClickHouseBlockChecksum real = ClickHouseBlockChecksum.calculateForBlock((byte)magic, compressedSizeWithHeader, uncompressedSize, block, compressedSize);
        if (!real.equals(expected)) {
            throw new IllegalArgumentException("Checksum doesn't match: corrupted data.");
        }
        byte[] decompressed = new byte[uncompressedSize];
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        decompressor.decompress(block, 0, decompressed, 0, uncompressedSize);
        return decompressed;
    }
}

