/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import com.ohaotian.plugin.common.util.RegUtils;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class CasAccessDecisionManager
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object o, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (null != configAttributes && configAttributes.size() > 0) {
            boolean flag;
            Iterator<ConfigAttribute> iter = configAttributes.iterator();
            do {
                if (!iter.hasNext()) {
                    return;
                }
                ConfigAttribute c = iter.next();
                String needUrl = c.getAttribute();
                flag = true;
                for (GrantedAuthority ga : authentication.getAuthorities()) {
                    if (!("URL_" + needUrl.trim()).contains(ga.getAuthority()) && !RegUtils.match((String)ga.getAuthority(), (String)("URL_" + needUrl.trim()))) continue;
                    flag = false;
                }
            } while (!flag);
            throw new AccessDeniedException("\u65e0\u6743\u9650\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

