/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainValidationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainValidationOption> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainValidationOption.getter(DomainValidationOption::domainName)).setter(DomainValidationOption.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> VALIDATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationDomain").getter(DomainValidationOption.getter(DomainValidationOption::validationDomain)).setter(DomainValidationOption.setter(Builder::validationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, VALIDATION_DOMAIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String validationDomain;

    private DomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationDomain = builder.validationDomain;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String validationDomain() {
        return this.validationDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationOption)) {
            return false;
        }
        DomainValidationOption other = (DomainValidationOption)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationDomain(), other.validationDomain());
    }

    public final String toString() {
        return ToString.builder((String)"DomainValidationOption").add("DomainName", (Object)this.domainName()).add("ValidationDomain", (Object)this.validationDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.validationDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainValidationOption, T> g) {
        return obj -> g.apply((DomainValidationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String validationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationOption model) {
            this.domainName(model.domainName);
            this.validationDomain(model.validationDomain);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        @Override
        @Transient
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public DomainValidationOption build() {
            return new DomainValidationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainValidationOption> {
        public Builder domainName(String var1);

        public Builder validationDomain(String var1);
    }
}

