/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.BranchDiffSourceCodeType;
import software.amazon.awssdk.services.codegurureviewer.model.CommitDiffSourceCodeType;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType;
import software.amazon.awssdk.services.codegurureviewer.model.RequestMetadata;
import software.amazon.awssdk.services.codegurureviewer.model.S3BucketRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCodeType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCodeType> {
    private static final SdkField<CommitDiffSourceCodeType> COMMIT_DIFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommitDiff").getter(SourceCodeType.getter(SourceCodeType::commitDiff)).setter(SourceCodeType.setter(Builder::commitDiff)).constructor(CommitDiffSourceCodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitDiff").build()}).build();
    private static final SdkField<RepositoryHeadSourceCodeType> REPOSITORY_HEAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RepositoryHead").getter(SourceCodeType.getter(SourceCodeType::repositoryHead)).setter(SourceCodeType.setter(Builder::repositoryHead)).constructor(RepositoryHeadSourceCodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryHead").build()}).build();
    private static final SdkField<BranchDiffSourceCodeType> BRANCH_DIFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BranchDiff").getter(SourceCodeType.getter(SourceCodeType::branchDiff)).setter(SourceCodeType.setter(Builder::branchDiff)).constructor(BranchDiffSourceCodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchDiff").build()}).build();
    private static final SdkField<S3BucketRepository> S3_BUCKET_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BucketRepository").getter(SourceCodeType.getter(SourceCodeType::s3BucketRepository)).setter(SourceCodeType.setter(Builder::s3BucketRepository)).constructor(S3BucketRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketRepository").build()}).build();
    private static final SdkField<RequestMetadata> REQUEST_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestMetadata").getter(SourceCodeType.getter(SourceCodeType::requestMetadata)).setter(SourceCodeType.setter(Builder::requestMetadata)).constructor(RequestMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_DIFF_FIELD, REPOSITORY_HEAD_FIELD, BRANCH_DIFF_FIELD, S3_BUCKET_REPOSITORY_FIELD, REQUEST_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final CommitDiffSourceCodeType commitDiff;
    private final RepositoryHeadSourceCodeType repositoryHead;
    private final BranchDiffSourceCodeType branchDiff;
    private final S3BucketRepository s3BucketRepository;
    private final RequestMetadata requestMetadata;

    private SourceCodeType(BuilderImpl builder) {
        this.commitDiff = builder.commitDiff;
        this.repositoryHead = builder.repositoryHead;
        this.branchDiff = builder.branchDiff;
        this.s3BucketRepository = builder.s3BucketRepository;
        this.requestMetadata = builder.requestMetadata;
    }

    public final CommitDiffSourceCodeType commitDiff() {
        return this.commitDiff;
    }

    public final RepositoryHeadSourceCodeType repositoryHead() {
        return this.repositoryHead;
    }

    public final BranchDiffSourceCodeType branchDiff() {
        return this.branchDiff;
    }

    public final S3BucketRepository s3BucketRepository() {
        return this.s3BucketRepository;
    }

    public final RequestMetadata requestMetadata() {
        return this.requestMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitDiff());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryHead());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchDiff());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeType)) {
            return false;
        }
        SourceCodeType other = (SourceCodeType)obj;
        return Objects.equals(this.commitDiff(), other.commitDiff()) && Objects.equals(this.repositoryHead(), other.repositoryHead()) && Objects.equals(this.branchDiff(), other.branchDiff()) && Objects.equals(this.s3BucketRepository(), other.s3BucketRepository()) && Objects.equals(this.requestMetadata(), other.requestMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"SourceCodeType").add("CommitDiff", (Object)this.commitDiff()).add("RepositoryHead", (Object)this.repositoryHead()).add("BranchDiff", (Object)this.branchDiff()).add("S3BucketRepository", (Object)this.s3BucketRepository()).add("RequestMetadata", (Object)this.requestMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommitDiff": {
                return Optional.ofNullable(clazz.cast(this.commitDiff()));
            }
            case "RepositoryHead": {
                return Optional.ofNullable(clazz.cast(this.repositoryHead()));
            }
            case "BranchDiff": {
                return Optional.ofNullable(clazz.cast(this.branchDiff()));
            }
            case "S3BucketRepository": {
                return Optional.ofNullable(clazz.cast(this.s3BucketRepository()));
            }
            case "RequestMetadata": {
                return Optional.ofNullable(clazz.cast(this.requestMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeType, T> g) {
        return obj -> g.apply((SourceCodeType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CommitDiffSourceCodeType commitDiff;
        private RepositoryHeadSourceCodeType repositoryHead;
        private BranchDiffSourceCodeType branchDiff;
        private S3BucketRepository s3BucketRepository;
        private RequestMetadata requestMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeType model) {
            this.commitDiff(model.commitDiff);
            this.repositoryHead(model.repositoryHead);
            this.branchDiff(model.branchDiff);
            this.s3BucketRepository(model.s3BucketRepository);
            this.requestMetadata(model.requestMetadata);
        }

        public final CommitDiffSourceCodeType.Builder getCommitDiff() {
            return this.commitDiff != null ? this.commitDiff.toBuilder() : null;
        }

        public final void setCommitDiff(CommitDiffSourceCodeType.BuilderImpl commitDiff) {
            this.commitDiff = commitDiff != null ? commitDiff.build() : null;
        }

        @Override
        @Transient
        public final Builder commitDiff(CommitDiffSourceCodeType commitDiff) {
            this.commitDiff = commitDiff;
            return this;
        }

        public final RepositoryHeadSourceCodeType.Builder getRepositoryHead() {
            return this.repositoryHead != null ? this.repositoryHead.toBuilder() : null;
        }

        public final void setRepositoryHead(RepositoryHeadSourceCodeType.BuilderImpl repositoryHead) {
            this.repositoryHead = repositoryHead != null ? repositoryHead.build() : null;
        }

        @Override
        @Transient
        public final Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead) {
            this.repositoryHead = repositoryHead;
            return this;
        }

        public final BranchDiffSourceCodeType.Builder getBranchDiff() {
            return this.branchDiff != null ? this.branchDiff.toBuilder() : null;
        }

        public final void setBranchDiff(BranchDiffSourceCodeType.BuilderImpl branchDiff) {
            this.branchDiff = branchDiff != null ? branchDiff.build() : null;
        }

        @Override
        @Transient
        public final Builder branchDiff(BranchDiffSourceCodeType branchDiff) {
            this.branchDiff = branchDiff;
            return this;
        }

        public final S3BucketRepository.Builder getS3BucketRepository() {
            return this.s3BucketRepository != null ? this.s3BucketRepository.toBuilder() : null;
        }

        public final void setS3BucketRepository(S3BucketRepository.BuilderImpl s3BucketRepository) {
            this.s3BucketRepository = s3BucketRepository != null ? s3BucketRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder s3BucketRepository(S3BucketRepository s3BucketRepository) {
            this.s3BucketRepository = s3BucketRepository;
            return this;
        }

        public final RequestMetadata.Builder getRequestMetadata() {
            return this.requestMetadata != null ? this.requestMetadata.toBuilder() : null;
        }

        public final void setRequestMetadata(RequestMetadata.BuilderImpl requestMetadata) {
            this.requestMetadata = requestMetadata != null ? requestMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder requestMetadata(RequestMetadata requestMetadata) {
            this.requestMetadata = requestMetadata;
            return this;
        }

        public SourceCodeType build() {
            return new SourceCodeType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCodeType> {
        public Builder commitDiff(CommitDiffSourceCodeType var1);

        default public Builder commitDiff(Consumer<CommitDiffSourceCodeType.Builder> commitDiff) {
            return this.commitDiff((CommitDiffSourceCodeType)((CommitDiffSourceCodeType.Builder)CommitDiffSourceCodeType.builder().applyMutation(commitDiff)).build());
        }

        public Builder repositoryHead(RepositoryHeadSourceCodeType var1);

        default public Builder repositoryHead(Consumer<RepositoryHeadSourceCodeType.Builder> repositoryHead) {
            return this.repositoryHead((RepositoryHeadSourceCodeType)((RepositoryHeadSourceCodeType.Builder)RepositoryHeadSourceCodeType.builder().applyMutation(repositoryHead)).build());
        }

        public Builder branchDiff(BranchDiffSourceCodeType var1);

        default public Builder branchDiff(Consumer<BranchDiffSourceCodeType.Builder> branchDiff) {
            return this.branchDiff((BranchDiffSourceCodeType)((BranchDiffSourceCodeType.Builder)BranchDiffSourceCodeType.builder().applyMutation(branchDiff)).build());
        }

        public Builder s3BucketRepository(S3BucketRepository var1);

        default public Builder s3BucketRepository(Consumer<S3BucketRepository.Builder> s3BucketRepository) {
            return this.s3BucketRepository((S3BucketRepository)((S3BucketRepository.Builder)S3BucketRepository.builder().applyMutation(s3BucketRepository)).build());
        }

        public Builder requestMetadata(RequestMetadata var1);

        default public Builder requestMetadata(Consumer<RequestMetadata.Builder> requestMetadata) {
            return this.requestMetadata((RequestMetadata)((RequestMetadata.Builder)RequestMetadata.builder().applyMutation(requestMetadata)).build());
        }
    }
}

