/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.AccountAggregationSource;
import software.amazon.awssdk.services.config.model.AccountAggregationSourceListCopier;
import software.amazon.awssdk.services.config.model.ConfigRequest;
import software.amazon.awssdk.services.config.model.OrganizationAggregationSource;
import software.amazon.awssdk.services.config.model.Tag;
import software.amazon.awssdk.services.config.model.TagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutConfigurationAggregatorRequest
extends ConfigRequest
implements ToCopyableBuilder<Builder, PutConfigurationAggregatorRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAggregatorName").getter(PutConfigurationAggregatorRequest.getter(PutConfigurationAggregatorRequest::configurationAggregatorName)).setter(PutConfigurationAggregatorRequest.setter(Builder::configurationAggregatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName").build()}).build();
    private static final SdkField<List<AccountAggregationSource>> ACCOUNT_AGGREGATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAggregationSources").getter(PutConfigurationAggregatorRequest.getter(PutConfigurationAggregatorRequest::accountAggregationSources)).setter(PutConfigurationAggregatorRequest.setter(Builder::accountAggregationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAggregationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OrganizationAggregationSource> ORGANIZATION_AGGREGATION_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OrganizationAggregationSource").getter(PutConfigurationAggregatorRequest.getter(PutConfigurationAggregatorRequest::organizationAggregationSource)).setter(PutConfigurationAggregatorRequest.setter(Builder::organizationAggregationSource)).constructor(OrganizationAggregationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAggregationSource").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutConfigurationAggregatorRequest.getter(PutConfigurationAggregatorRequest::tags)).setter(PutConfigurationAggregatorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_AGGREGATOR_NAME_FIELD, ACCOUNT_AGGREGATION_SOURCES_FIELD, ORGANIZATION_AGGREGATION_SOURCE_FIELD, TAGS_FIELD));
    private final String configurationAggregatorName;
    private final List<AccountAggregationSource> accountAggregationSources;
    private final OrganizationAggregationSource organizationAggregationSource;
    private final List<Tag> tags;

    private PutConfigurationAggregatorRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
        this.tags = builder.tags;
    }

    public final String configurationAggregatorName() {
        return this.configurationAggregatorName;
    }

    public final boolean hasAccountAggregationSources() {
        return this.accountAggregationSources != null && !(this.accountAggregationSources instanceof SdkAutoConstructList);
    }

    public final List<AccountAggregationSource> accountAggregationSources() {
        return this.accountAggregationSources;
    }

    public final OrganizationAggregationSource organizationAggregationSource() {
        return this.organizationAggregationSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAggregationSources() ? this.accountAggregationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationAggregationSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationAggregatorRequest)) {
            return false;
        }
        PutConfigurationAggregatorRequest other = (PutConfigurationAggregatorRequest)((Object)obj);
        return Objects.equals(this.configurationAggregatorName(), other.configurationAggregatorName()) && this.hasAccountAggregationSources() == other.hasAccountAggregationSources() && Objects.equals(this.accountAggregationSources(), other.accountAggregationSources()) && Objects.equals(this.organizationAggregationSource(), other.organizationAggregationSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutConfigurationAggregatorRequest").add("ConfigurationAggregatorName", (Object)this.configurationAggregatorName()).add("AccountAggregationSources", this.hasAccountAggregationSources() ? this.accountAggregationSources() : null).add("OrganizationAggregationSource", (Object)this.organizationAggregationSource()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationAggregatorName": {
                return Optional.ofNullable(clazz.cast(this.configurationAggregatorName()));
            }
            case "AccountAggregationSources": {
                return Optional.ofNullable(clazz.cast(this.accountAggregationSources()));
            }
            case "OrganizationAggregationSource": {
                return Optional.ofNullable(clazz.cast(this.organizationAggregationSource()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationAggregatorRequest, T> g) {
        return obj -> g.apply((PutConfigurationAggregatorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigRequest.BuilderImpl
    implements Builder {
        private String configurationAggregatorName;
        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();
        private OrganizationAggregationSource organizationAggregationSource;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationAggregatorRequest model) {
            super(model);
            this.configurationAggregatorName(model.configurationAggregatorName);
            this.accountAggregationSources(model.accountAggregationSources);
            this.organizationAggregationSource(model.organizationAggregationSource);
            this.tags(model.tags);
        }

        public final String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        @Transient
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final List<AccountAggregationSource.Builder> getAccountAggregationSources() {
            List<AccountAggregationSource.Builder> result = AccountAggregationSourceListCopier.copyToBuilder(this.accountAggregationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        @Override
        @Transient
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource ... accountAggregationSources) {
            this.accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... accountAggregationSources) {
            this.accountAggregationSources(Stream.of(accountAggregationSources).map(c -> (AccountAggregationSource)((AccountAggregationSource.Builder)AccountAggregationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return this.organizationAggregationSource != null ? this.organizationAggregationSource.toBuilder() : null;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build() : null;
        }

        @Override
        @Transient
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationAggregatorRequest build() {
            return new PutConfigurationAggregatorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutConfigurationAggregatorRequest> {
        public Builder configurationAggregatorName(String var1);

        public Builder accountAggregationSources(Collection<AccountAggregationSource> var1);

        public Builder accountAggregationSources(AccountAggregationSource ... var1);

        public Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder> ... var1);

        public Builder organizationAggregationSource(OrganizationAggregationSource var1);

        default public Builder organizationAggregationSource(Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return this.organizationAggregationSource((OrganizationAggregationSource)((OrganizationAggregationSource.Builder)OrganizationAggregationSource.builder().applyMutation(organizationAggregationSource)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

