/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRule;

public class DescribeOrganizationConfigRulesIterable
implements SdkIterable<DescribeOrganizationConfigRulesResponse> {
    private final ConfigClient client;
    private final DescribeOrganizationConfigRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrganizationConfigRulesIterable(ConfigClient client, DescribeOrganizationConfigRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrganizationConfigRulesResponseFetcher();
    }

    public Iterator<DescribeOrganizationConfigRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationConfigRule> organizationConfigRules() {
        Function<DescribeOrganizationConfigRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConfigRules() != null) {
                return response.organizationConfigRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOrganizationConfigRulesResponseFetcher
    implements SyncPageFetcher<DescribeOrganizationConfigRulesResponse> {
        private DescribeOrganizationConfigRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConfigRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOrganizationConfigRulesResponse nextPage(DescribeOrganizationConfigRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConfigRulesIterable.this.client.describeOrganizationConfigRules(DescribeOrganizationConfigRulesIterable.this.firstRequest);
            }
            return DescribeOrganizationConfigRulesIterable.this.client.describeOrganizationConfigRules((DescribeOrganizationConfigRulesRequest)((Object)DescribeOrganizationConfigRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

